\                   PCI expansion PROM header
\        00000000:                              PCI magic number (55AA): 55AA
\        00000002:                             Pointer to FCode program: 0040
\        00000004:      Reserved for processor architecture-unique data: 00000000 00000000 00000000 00000000 00000000  ....................
\        00000018:               Pointer to start of PCI Data Structure: 0020
\        0000001A:                                            Pad bytes: 0000
\                                             Variable length pad bytes:
\        0000001C: 00000000                                                                 ....
\                   PCI Data Structure (4 byte aligned)
\        00000020:                              Signature string (PCIR): PCIR
\        00000024:                         Vendor ID = config reg 00/01: 9004
\        00000026:                         Device ID = config reg 02/03: 5078
\        00000028:                        Pointer to Vital Product Data: 0000
\        0000002A:                            PCI Data Structure length: 0020
\        0000002C:                          PCI Data Structure revision: 00 = PCI 2.2
\        0000002D:                     Class Code = config reg 09/0a/0b: 010000 (Class code / Subclass code / Programming interface code)
\        00000030:                            Image Length in 512 bytes: 0023 (* 0x200 = 0x4600)
\        00000032:                          Revision Level of Code/Data: 0000
\        00000034:                                            Code Type: 01 = Open Firmware
\        00000035:                                            Indicator: 80 = last image
\        00000036:                                             Reserved: 0000
\                                             Variable length pad bytes:
\        00000038: 00000000 00000000                                                        ........

hex

tokenizer[ 0000 ]tokenizer set-rev-level
tokenizer[ 0020 ]tokenizer pci-data-structure-start
tokenizer[ 0020 ]tokenizer pci-data-structure-length
tokenizer[ 9004 5078 010000 ]tokenizer pci-header
tokenizer[ 4600 ]tokenizer rom-size

fcode-version2																	\					[0f1]
\ format:    0x08
\ checksum:  0x6949 (ok)
\ len:       0x4532 (17714 bytes)
hex

" ADPT,2930CU"																	\					[012]
device-name																		\					[201]
" scsi"																			\					[012]
device-type																		\					[11a]
" ADPT,1686806-04"																\					[012]
model																			\					[119]
" ADPT,AIC-7856"																\					[012]
encode-string																	\					[114]
" compatible"																	\					[012]
property																		\					[110]
" 4.2"																			\					[012]
encode-string																	\					[114]
" ADPT,fcode-version"															\					[012]
property																		\					[110]
" 10/05/99"																		\					[012]
encode-string																	\					[114]
" ADPT,fcode-date"																\					[012]
property																		\					[110]

headers

-1 constant 785x-6x?															\ (800 -1)			[0a4 0b6 0ba]
0 constant 788x?																\ (801 0)			[0a5 0b6 0ba]
0 constant 7890-91?																\ (802 0)			[0a5 0b6 0ba]
0 constant 7896-97?																\ (803 0)			[0a5 0b6 0ba]
0 constant 7899?																\ (804 0)			[0a5 0b6 0ba]
0 constant 7892?																\ (805 0)			[0a5 0b6 0ba]
-1 constant apple-max-transfer?													\ (806 -1)			[0a4 0b6 0ba]
1000 constant /scsi-regs														\ (807 1000)		[010 0b6 0ba]
0 value 789x?																	\ (808 0)			[0a5 0b6 0b8]
0 value #channels																\ (809 0)			[0a5 0b6 0b8]
0 value #targets																\ (80a 0)			[0a5 0b6 0b8]
0 value /rom																	\ (80b 0)			[0a5 0b6 0b8]
-1 value channel-a																\ (80c -1)			[0a4 0b6 0b8]
7896-97?																		\					[803]
if																				\ (0xa)				[014]
	2																			\					[0a7]
	to #channels																\					[0c3 809]
else																			\ (0x8)				[013 0b2]
	1																			\					[0a6]
	to #channels																\					[0c3 809]
then																			\					[0b2]
785x-6x?																		\					[800]
if																				\ (0xe)				[014]
	8																			\					[010]
	to #targets																	\					[0c3 80a]
else																			\ (0xc)				[013 0b2]
	10																			\					[010]
	to #targets																	\					[0c3 80a]
then																			\					[0b2]
7890-91?																		\					[802]
7896-97?																		\					[803]
or																				\					[024]
if																				\ (0x12)			[014]
	-1																			\					[0a4]
	to 789x?																	\					[0c3 808]
	20000																		\					[010]
	to /rom																		\					[0c3 80b]
else																			\ (0x10)			[013 0b2]
	0																			\					[0a5]
	to 789x?																	\					[0c3 808]
	10000																		\					[010]
	to /rom																		\					[0c3 80b]
then																			\					[0b2]
0 value debug?																	\ (80d 0)			[0a5 0b6 0b8]


external

: set-debug-mode																\ (80e)				[0ca 0b7]
	-1																			\					[0a4]
	to debug?																	\					[0c3 80d]
	;																			\					[0c2]

0																				\					[0a5]
0																				\					[0a5]
my-space																		\					[103]
encode-phys																		\					[113]
0																				\					[0a5]
encode-int																		\					[111]
encode+																			\					[112]
0																				\					[0a5]
encode-int																		\					[111]
encode+																			\					[112]
0																				\					[0a5]
0																				\					[0a5]
my-space																		\					[103]
2000014																			\					[010]
+																				\					[01e]
encode-phys																		\					[113]
encode+																			\					[112]
0																				\					[0a5]
encode-int																		\					[111]
encode+																			\					[112]
/scsi-regs																		\					[807]
encode-int																		\					[111]
encode+																			\					[112]
0																				\					[0a5]
0																				\					[0a5]
my-space																		\					[103]
2000030																			\					[010]
+																				\					[01e]
encode-phys																		\					[113]
encode+																			\					[112]
0																				\					[0a5]
encode-int																		\					[111]
encode+																			\					[112]
/rom																			\					[80b]
encode-int																		\					[111]
encode+																			\					[112]
" reg"																			\					[012]
property																		\					[110]
0																				\					[0a5]
encode-int																		\					[111]
0																				\					[0a5]
encode-int																		\					[111]
encode+																			\					[112]
30d40																			\					[010]
encode-int																		\					[111]
encode+																			\					[112]
55730																			\					[010]
encode-int																		\					[111]
encode+																			\					[112]
0																				\					[0a5]
encode-int																		\					[111]
encode+																			\					[112]
0																				\					[0a5]
encode-int																		\					[111]
encode+																			\					[112]
249f0																			\					[010]
encode-int																		\					[111]
encode+																			\					[112]
55730																			\					[010]
encode-int																		\					[111]
encode+																			\					[112]
" power-consumption"															\					[012]
property																		\					[110]


headers

: warning																		\ (80f)				[0b6 0b7]
	debug?																		\					[80d]
	if																			\ (0x5)				[014]
		type																	\					[090]
		cr																		\					[092]
	then																		\					[0b2]
	" ADPT,warning"																\					[012]
	get-my-property																\					[21a]
	if																			\ (0x8)				[014]
		encode-string															\					[114]
	else																		\ (0xb)				[013 0b2]
		encode-bytes															\					[115]
		2swap																	\					[055]
		encode-string															\					[114]
		encode+																	\					[112]
	then																		\					[0b2]
	" ADPT,warning"																\					[012]
	property																	\					[110]
	;																			\					[0c2]


: my-l@																			\ (810)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-l@"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: my-l!																			\ (811)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-l!"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: my-w@																			\ (812)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-w@"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: my-w!																			\ (813)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-w!"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: my-b@																			\ (814)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-b@"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: my-b!																			\ (815)				[0b6 0b7]
	my-space																	\					[103]
	+																			\					[01e]
	" config-b!"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: subsysid@																		\ (816)				[0b6 0b7]
	2e																			\					[010]
	my-w@																		\					[812]
	;																			\					[0c2]


: get-base-address																\ (817)				[0b6 0b7]
	" assigned-addresses"														\					[012]
	get-my-property																\					[21a]
	if																			\ (0x25)			[014]
		." No address property found!"											\					[012 090]
		cr																		\					[092]
		0																		\					[0a5]
		0																		\					[0a5]
		rot																		\					[04a]
		exit																	\					[033]
	then																		\					[0b2]
	rot																			\					[04a]
	>r																			\					[030]
	begin																		\					[0b1]
		dup																		\					[047]
		while																	\ (0x29)			[014]
			decode-phys															\					[128]
			0ff																	\					[010]
			and																	\					[023]
			r@																	\					[032]
			0ff																	\					[010]
			and																	\					[023]
			=																	\					[03c]
			if																	\ (0xa)				[014]
				2swap															\					[055]
				2drop															\					[052]
				r>																\					[031]
				exit															\					[033]
			else																\ (0x5)				[013 0b2]
				2drop															\					[052]
			then																\					[0b2]
			decode-int															\					[21b]
			drop																\					[046]
			decode-int															\					[21b]
			drop																\					[046]
	repeat																		\ (0xffd8)			[013 0b2]
	2drop																		\					[052]
	." Base address not assigned!"												\					[012 090]
	cr																			\					[092]
	0																			\					[0a5]
	0																			\					[0a5]
	r>																			\					[031]
	;																			\					[0c2]



external

: map-in																		\ (818)				[0ca 0b7]
	" map-in"																	\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: map-out																		\ (819)				[0ca 0b7]
	" map-out"																	\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: dma-map-in																	\ (81a)				[0ca 0b7]
	" dma-map-in"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: dma-alloc																		\ (81b)				[0ca 0b7]
	" dma-alloc"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: dma-free																		\ (81c)				[0ca 0b7]
	" dma-free"																	\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


headers

0 value io-base																	\ (81d 0)			[0a5 0b6 0b8]
0 value mem-base																\ (81e 0)			[0a5 0b6 0b8]

: map-io-regs																	\ (81f)				[0b6 0b7]
	0																			\					[0a5]
	0																			\					[0a5]
	my-space																	\					[103]
	1000010																		\					[010]
	+																			\					[01e]
	/scsi-regs																	\					[807]
	map-in																		\					[818]
	to io-base																	\					[0c3 81d]
	4																			\					[010]
	my-w@																		\					[812]
	1																			\					[0a6]
	or																			\					[024]
	4																			\					[010]
	my-w!																		\					[813]
	;																			\					[0c2]


: unmap-io-regs																	\ (820)				[0b6 0b7]
	io-base																		\					[81d]
	/scsi-regs																	\					[807]
	map-out																		\					[819]
	-1																			\					[0a4]
	to io-base																	\					[0c3 81d]
	4																			\					[010]
	my-w@																		\					[812]
	1																			\					[0a6]
	invert																		\					[026]
	and																			\					[023]
	4																			\					[010]
	my-w!																		\					[813]
	;																			\					[0c2]


: map-mem-regs																	\ (821)				[0b6 0b7]
	my-space																	\					[103]
	82000014																	\					[010]
	+																			\					[01e]
	get-base-address															\					[817]
	/scsi-regs																	\					[807]
	map-in																		\					[818]
	to mem-base																	\					[0c3 81e]
	4																			\					[010]
	my-w@																		\					[812]
	6																			\					[010]
	or																			\					[024]
	4																			\					[010]
	my-w!																		\					[813]
	;																			\					[0c2]


: unmap-mem-regs																\ (822)				[0b6 0b7]
	mem-base																	\					[81e]
	/scsi-regs																	\					[807]
	map-out																		\					[819]
	-1																			\					[0a4]
	to mem-base																	\					[0c3 81e]
	4																			\					[010]
	my-w@																		\					[812]
	6																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	4																			\					[010]
	my-w!																		\					[813]
	;																			\					[0c2]


: mem-b@																		\ (823)				[0b6 0b7]
	mem-base																	\					[81e]
	ca+																			\					[05e]
	rb@																			\					[230]
	;																			\					[0c2]


: mem-b!																		\ (824)				[0b6 0b7]
	mem-base																	\					[81e]
	ca+																			\					[05e]
	rb!																			\					[231]
	;																			\					[0c2]

0 value dummy-v																	\ (825 0)			[0a5 0b6 0b8]
0 value dummy-p																	\ (826 0)			[0a5 0b6 0b8]
20 value /dummy																	\ (827 20)			[010 0b6 0b8]

: get-phys-addr																	\ (828)				[0b6 0b7]
	?dup																		\					[050]
	if																			\ (0x9)				[014]
		0																		\					[0a5]
		dma-map-in																\					[81a]
	else																		\ (0x7)				[013 0b2]
		drop																	\					[046]
		dummy-p																	\					[826]
	then																		\					[0b2]
	;																			\					[0c2]


: create-dummy																	\ (829)				[0b6 0b7]
	/dummy																		\					[827]
	dma-alloc																	\					[81b]
	to dummy-v																	\					[0c3 825]
	dummy-v																		\					[825]
	/dummy																		\					[827]
	get-phys-addr																\					[828]
	to dummy-p																	\					[0c3 826]
	dummy-v																		\					[825]
	/dummy																		\					[827]
	erase																		\					[0a5 079]
	;																			\					[0c2]


: free-dummy																	\ (82a)				[0b6 0b7]
	dummy-v																		\					[825]
	/dummy																		\					[827]
	dma-free																	\					[81c]
	0																			\					[0a5]
	to dummy-p																	\					[0c3 826]
	0																			\					[0a5]
	to dummy-v																	\					[0c3 825]
	;																			\					[0c2]


: scsiseq@																		\ (82b)				[0b6 0b7]
	0																			\					[0a5]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scsiseq!																		\ (82c)				[0b6 0b7]
	0																			\					[0a5]
	mem-b!																		\					[824]
	;																			\					[0c2]


: sxfrctl0@																		\ (82d)				[0b6 0b7]
	1																			\					[0a6]
	mem-b@																		\					[823]
	;																			\					[0c2]


: sxfrctl0!																		\ (82e)				[0b6 0b7]
	1																			\					[0a6]
	mem-b!																		\					[824]
	;																			\					[0c2]


: sxfrctl1@																		\ (82f)				[0b6 0b7]
	2																			\					[0a7]
	mem-b@																		\					[823]
	;																			\					[0c2]


: sxfrctl1!																		\ (830)				[0b6 0b7]
	2																			\					[0a7]
	mem-b!																		\					[824]
	;																			\					[0c2]


: scsisig@																		\ (831)				[0b6 0b7]
	3																			\					[0a8]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scsisig!																		\ (832)				[0b6 0b7]
	3																			\					[0a8]
	mem-b!																		\					[824]
	;																			\					[0c2]


: scsi-rate@																	\ (833)				[0b6 0b7]
	4																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scsi-rate!																	\ (834)				[0b6 0b7]
	4																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: scsidatl@																		\ (835)				[0b6 0b7]
	6																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scsidatl!																		\ (836)				[0b6 0b7]
	6																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: scsi-int0!																	\ (837)				[0b6 0b7]
	0b																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: scsi-stat0@																	\ (838)				[0b6 0b7]
	0b																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scsi-int1!																	\ (839)				[0b6 0b7]
	0c																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: scsi-stat1@																	\ (83a)				[0b6 0b7]
	0c																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scsi-stat2@																	\ (83b)				[0b6 0b7]
	0d																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scsi-stat3@																	\ (83c)				[0b6 0b7]
	0e																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scsi-id-reg																	\ (83d)				[0b6 0b7]
	789x?																		\					[808]
	if																			\ (0xb)				[014]
		0f																		\					[010]
	else																		\ (0x9)				[013 0b2]
		5																		\					[010]
	then																		\					[0b2]
	;																			\					[0c2]


: scsi-id@																		\ (83e)				[0b6 0b7]
	scsi-id-reg																	\					[83d]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scsi-id!																		\ (83f)				[0b6 0b7]
	scsi-id-reg																	\					[83d]
	mem-b!																		\					[824]
	;																			\					[0c2]


: simode0@																		\ (840)				[0b6 0b7]
	10																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: simode0!																		\ (841)				[0b6 0b7]
	10																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: simode1@																		\ (842)				[0b6 0b7]
	11																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: simode1!																		\ (843)				[0b6 0b7]
	11																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: brdctl@																		\ (844)				[0b6 0b7]
	1d																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: brdctl!																		\ (845)				[0b6 0b7]
	1d																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: seectl@																		\ (846)				[0b6 0b7]
	1e																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: seectl!																		\ (847)				[0b6 0b7]
	1e																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: sblkctl@																		\ (848)				[0b6 0b7]
	1f																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: sblkctl!																		\ (849)				[0b6 0b7]
	1f																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: scratch@																		\ (84a)				[0b6 0b7]
	20																			\					[010]
	+																			\					[01e]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scratch!																		\ (84b)				[0b6 0b7]
	20																			\					[010]
	+																			\					[01e]
	mem-b!																		\					[824]
	;																			\					[0c2]


: seq-ctl@																		\ (84c)				[0b6 0b7]
	60																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: seq-ctl!																		\ (84d)				[0b6 0b7]
	60																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: (seq-data@)																	\ (84e)				[0b6 0b7]
	61																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: (seq-data!)																	\ (84f)				[0b6 0b7]
	61																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: devconfig@																	\ (850)				[0b6 0b7]
	40																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: devconfig!																	\ (851)				[0b6 0b7]
	40																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: seq-data@																		\ (852)				[0b6 0b7]
	4																			\					[010]
	0																			\					[0a5]
	do																			\ (0x7)				[017]
		(seq-data@)																\					[84e]
	loop																		\ (0xfffd)			[015]
	bljoin																		\					[07f]
	;																			\					[0c2]


: seq-data!																		\ (853)				[0b6 0b7]
	lbsplit																		\					[07e]
	>r																			\					[030]
	>r																			\					[030]
	>r																			\					[030]
	(seq-data!)																	\					[84f]
	r>																			\					[031]
	(seq-data!)																	\					[84f]
	r>																			\					[031]
	(seq-data!)																	\					[84f]
	r>																			\					[031]
	(seq-data!)																	\					[84f]
	;																			\					[0c2]


: seq-addr@																		\ (854)				[0b6 0b7]
	62																			\					[010]
	mem-b@																		\					[823]
	63																			\					[010]
	mem-b@																		\					[823]
	bwjoin																		\					[0b0]
	;																			\					[0c2]


: seq-addr!																		\ (855)				[0b6 0b7]
	wbsplit																		\					[0af]
	3																			\					[010]
	and																			\					[023]
	swap																		\					[049]
	62																			\					[010]
	mem-b!																		\					[824]
	63																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: brkaddr!																		\ (856)				[0b6 0b7]
	68																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: hcntrl@																		\ (857)				[0b6 0b7]
	87																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: hcntrl!																		\ (858)				[0b6 0b7]
	87																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: dscmd1@																		\ (859)				[0b6 0b7]
	85																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: dscmd1!																		\ (85a)				[0b6 0b7]
	85																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: chip-reset																	\ (85b)				[0b6 0b7]
	hcntrl@																		\					[857]
	1																			\					[0a6]
	or																			\					[024]
	hcntrl!																		\					[858]
	10																			\					[010]
	ms																			\					[126]
	begin																		\					[0b1]
		hcntrl@																	\					[857]
		1																		\					[0a6]
		and																		\					[023]
	until																		\ (0xfffb)			[014]
	hcntrl@																		\					[857]
	1																			\					[0a6]
	invert																		\					[026]
	and																			\					[023]
	hcntrl!																		\					[858]
	;																			\					[0c2]


: haddr!																		\ (85c)				[0b6 0b7]
	lbsplit																		\					[07e]
	0																			\					[0a5]
	dscmd1!																		\					[85a]
	3																			\					[0a8]
	roll																		\					[04f]
	88																			\					[010]
	mem-b!																		\					[824]
	rot																			\					[04a]
	89																			\					[010]
	mem-b!																		\					[824]
	swap																		\					[049]
	8a																			\					[010]
	mem-b!																		\					[824]
	8b																			\					[010]
	mem-b!																		\					[824]
	1																			\					[0a6]
	dscmd1!																		\					[85a]
	4																			\					[010]
	0																			\					[0a5]
	do																			\ (0xf)				[017]
		0																		\					[0a5]
		88																		\					[010]
		i																		\					[019]
		+																		\					[01e]
		mem-b!																	\					[824]
	loop																		\ (0xfff5)			[015]
	;																			\					[0c2]


: hcnt!																			\ (85d)				[0b6 0b7]
	lbsplit																		\					[07e]
	drop																		\					[046]
	rot																			\					[04a]
	8c																			\					[010]
	mem-b!																		\					[824]
	swap																		\					[049]
	8d																			\					[010]
	mem-b!																		\					[824]
	8e																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: dfcntrl@																		\ (85e)				[0b6 0b7]
	93																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: dfcntrl!																		\ (85f)				[0b6 0b7]
	93																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: pci>df																		\ (860)				[0b6 0b7]
	dfcntrl@																	\					[85e]
	4																			\					[010]
	or																			\					[024]
	dfcntrl!																	\					[85f]
	;																			\					[0c2]


: df>pci																		\ (861)				[0b6 0b7]
	dfcntrl@																	\					[85e]
	4																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	dfcntrl!																	\					[85f]
	;																			\					[0c2]


: enable-df																		\ (862)				[0b6 0b7]
	dfcntrl@																	\					[85e]
	28																			\					[010]
	or																			\					[024]
	dfcntrl!																	\					[85f]
	;																			\					[0c2]


: disable-df																	\ (863)				[0b6 0b7]
	dfcntrl@																	\					[85e]
	28																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	dfcntrl!																	\					[85f]
	begin																		\					[0b1]
		dfcntrl@																\					[85e]
		28																		\					[010]
		and																		\					[023]
		0=																		\					[034]
	until																		\ (0xfff6)			[014]
	;																			\					[0c2]


: scbptr@																		\ (864)				[0b6 0b7]
	90																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scbptr!																		\ (865)				[0b6 0b7]
	90																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: intstat@																		\ (866)				[0b6 0b7]
	91																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: error@																		\ (867)				[0b6 0b7]
	92																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: clrint!																		\ (868)				[0b6 0b7]
	92																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: scbcnt@																		\ (869)				[0b6 0b7]
	9a																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scbcnt!																		\ (86a)				[0b6 0b7]
	9a																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: scbram@																		\ (86b)				[0b6 0b7]
	0a0																			\					[010]
	+																			\					[01e]
	mem-b@																		\					[823]
	;																			\					[0c2]


: scbram!																		\ (86c)				[0b6 0b7]
	0a0																			\					[010]
	+																			\					[01e]
	mem-b!																		\					[824]
	;																			\					[0c2]

0 value sg-list-v																\ (86d 0)			[0a5 0b6 0b8]
0 value sg-list-p																\ (86e 0)			[0a5 0b6 0b8]
20 constant /sg-list															\ (86f 20)			[010 0b6 0ba]

: create-sg-list																\ (870)				[0b6 0b7]
	/sg-list																	\					[86f]
	dma-alloc																	\					[81b]
	to sg-list-v																\					[0c3 86d]
	sg-list-v																	\					[86d]
	/sg-list																	\					[86f]
	get-phys-addr																\					[828]
	to sg-list-p																\					[0c3 86e]
	;																			\					[0c2]


: free-sg-list																	\ (871)				[0b6 0b7]
	sg-list-v																	\					[86d]
	/sg-list																	\					[86f]
	dma-free																	\					[81c]
	0																			\					[0a5]
	to sg-list-v																\					[0c3 86d]
	0																			\					[0a5]
	to sg-list-p																\					[0c3 86e]
	;																			\					[0c2]


: >sg-list																		\ (872)				[0b6 0b7]
	dup																			\					[047]
	lbsplit																		\					[07e]
	drop																		\					[046]
	sg-list-v																	\					[86d]
	6																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	sg-list-v																	\					[86d]
	5																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	sg-list-v																	\					[86d]
	4																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	get-phys-addr																\					[828]
	lbsplit																		\					[07e]
	sg-list-v																	\					[86d]
	3																			\					[0a8]
	ca+																			\					[05e]
	c!																			\					[075]
	sg-list-v																	\					[86d]
	2																			\					[0a7]
	ca+																			\					[05e]
	c!																			\					[075]
	sg-list-v																	\					[86d]
	char+																		\					[062]
	c!																			\					[075]
	sg-list-v																	\					[86d]
	c!																			\					[075]
	;																			\					[0c2]

0 value cdb-adr																	\ (873 0)			[0a5 0b6 0b8]
0 value cdb-len																	\ (874 0)			[0a5 0b6 0b8]

: setup-cdb																		\ (875)				[0b6 0b7]
	dup																			\					[047]
	dma-alloc																	\					[81b]
	dup																			\					[047]
	to cdb-adr																	\					[0c3 873]
	over																		\					[048]
	to cdb-len																	\					[0c3 874]
	swap																		\					[049]
	move																		\					[078]
	;																			\					[0c2]


: free-cdb																		\ (876)				[0b6 0b7]
	cdb-adr																		\					[873]
	cdb-len																		\					[874]
	dma-free																	\					[81c]
	0																			\					[0a5]
	to cdb-adr																	\					[0c3 873]
	0																			\					[0a5]
	to cdb-len																	\					[0c3 874]
	;																			\					[0c2]

-1 instance value my-id															\ (877 -1)			[0a4 0c0 0b6 0b8]
-1 instance value his-id														\ (878 -1)			[0a4 0c0 0b6 0b8]
-1 instance value his-lun														\ (879 -1)			[0a4 0c0 0b6 0b8]


external

: set-address																	\ (87a)				[0ca 0b7]
	to his-id																	\					[0c3 878]
	to his-lun																	\					[0c3 879]
	;																			\					[0c2]


: set-my-id																		\ (87b)				[0ca 0b7]
	dup																			\					[047]
	to my-id																	\					[0c3 877]
	scsi-id@																	\					[83e]
	0f																			\					[010]
	and																			\					[023]
	or																			\					[024]
	scsi-id!																	\					[83f]
	;																			\					[0c2]


headers

0 value scb																		\ (87c 0)			[0a5 0b6 0b8]
20 constant /scb																\ (87d 20)			[010 0b6 0ba]

: allocate-scb																	\ (87e)				[0b6 0b7]
	/scb																		\					[87d]
	dma-alloc																	\					[81b]
	to scb																		\					[0c3 87c]
	scb																			\					[87c]
	/scb																		\					[87d]
	erase																		\					[0a5 079]
	;																			\					[0c2]


: free-scb																		\ (87f)				[0b6 0b7]
	scb																			\					[87c]
	/scb																		\					[87d]
	dma-free																	\					[81c]
	0																			\					[0a5]
	to scb																		\					[0c3 87c]
	;																			\					[0c2]


: setup-scb																		\ (880)				[0b6 0b7]
	setup-cdb																	\					[875]
	drop																		\					[046]
	>sg-list																	\					[872]
	allocate-scb																\					[87e]
	sg-list-p																	\					[86e]
	lbsplit																		\					[07e]
	scb																			\					[87c]
	7																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[87c]
	6																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[87c]
	5																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[87c]
	4																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	1																			\					[0a6]
	scb																			\					[87c]
	3																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	cdb-len																		\					[874]
	scb																			\					[87c]
	2																			\					[0a7]
	ca+																			\					[05e]
	c!																			\					[075]
	cdb-adr																		\					[873]
	cdb-len																		\					[874]
	get-phys-addr																\					[828]
	lbsplit																		\					[07e]
	scb																			\					[87c]
	0b																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[87c]
	0a																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[87c]
	9																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	scb																			\					[87c]
	8																			\					[010]
	ca+																			\					[05e]
	c!																			\					[075]
	his-id																		\					[878]
	4																			\					[010]
	lshift																		\					[027]
	his-lun																		\					[879]
	or																			\					[024]
	scb																			\					[87c]
	c!																			\					[075]
	;																			\					[0c2]


: teardown-scb																	\ (881)				[0b6 0b7]
	free-cdb																	\					[876]
	free-scb																	\					[87f]
	;																			\					[0c2]

40 constant /nvram-size															\ (882 40)			[010 0b6 0ba]
create nvram-buffer																\ (883)				[0b6 0bb]
/nvram-size																		\					[882]
allot																			\					[0a5 02f 0a5 018 0a5 0d0 015]
0 value nvram-type																\ (884 0)			[0a5 0b6 0b8]
0 value nvram-valid																\ (885 0)			[0a5 0b6 0b8]

: nvram@																		\ (886)				[0b6 0b7]
	nvram-buffer																\					[883]
	swap																		\					[049]
	ca+																			\					[05e]
	c@																			\					[071]
	;																			\					[0c2]


: nvram!																		\ (887)				[0b6 0b7]
	nvram-buffer																\					[883]
	swap																		\					[049]
	ca+																			\					[05e]
	c!																			\					[075]
	;																			\					[0c2]


: nvram-on																		\ (888)				[0b6 0b7]
	20																			\					[010]
	seectl!																		\					[847]
	begin																		\					[0b1]
		seectl@																	\					[846]
		10																		\					[010]
		and																		\					[023]
	until																		\ (0xfff7)			[014]
	;																			\					[0c2]


: nvram-off																		\ (889)				[0b6 0b7]
	0																			\					[0a5]
	seectl!																		\					[847]
	;																			\					[0c2]


: get-nvram-type																\ (88a)				[0b6 0b7]
	0																			\					[0a5]
	to nvram-type																\					[0c3 884]
	789x?																		\					[808]
	if																			\ (0x19)			[014]
		subsysid@																\					[816]
		300																		\					[010]
		and																		\					[023]
		200																		\					[010]
		=																		\					[03c]
		if																		\ (0x7)				[014]
			1																	\					[0a6]
			to nvram-type														\					[0c3 884]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]


: nvram-delay																	\ (88b)				[0b6 0b7]
	3																			\					[0a8]
	0																			\					[0a5]
	do																			\ (0x14)			[017]
		begin																	\					[0b1]
			seectl@																\					[846]
			10																	\					[010]
			and																	\					[023]
		until																	\ (0xfff7)			[014]
		dup																		\					[047]
		seectl!																	\					[847]
	loop																		\ (0xfff0)			[015]
	drop																		\					[046]
	;																			\					[0c2]


: nvram-send-start-bit															\ (88c)				[0b6 0b7]
	2a																			\					[010]
	dup																			\					[047]
	seectl!																		\					[847]
	nvram-delay																	\					[88b]
	2e																			\					[010]
	dup																			\					[047]
	seectl!																		\					[847]
	nvram-delay																	\					[88b]
	2a																			\					[010]
	dup																			\					[047]
	seectl!																		\					[847]
	nvram-delay																	\					[88b]
	;																			\					[0c2]


: nvram-send-address															\ (88d)				[0b6 0b7]
	1																			\					[0a6]
	swap																		\					[049]
	1-																			\					[0a6 01f]
	lshift																		\					[027]
	begin																		\					[0b1]
		2dup																	\					[053]
		and																		\					[023]
		if																		\ (0xb)				[014]
			2a																	\					[010]
		else																	\ (0x9)				[013 0b2]
			28																	\					[010]
		then																	\					[0b2]
		dup																		\					[047]
		dup																		\					[047]
		seectl!																	\					[847]
		nvram-delay																\					[88b]
		4																		\					[010]
		or																		\					[024]
		dup																		\					[047]
		seectl!																	\					[847]
		nvram-delay																\					[88b]
		2/																		\					[057]
		dup																		\					[047]
		0=																		\					[034]
	until																		\ (0xffd7)			[014]
	2drop																		\					[052]
	;																			\					[0c2]


: nvram-read-register															\ (88e)				[0b6 0b7]
	nvram-type																	\					[884]
	if																			\ (0x11)			[014]
		200																		\					[010]
		or																		\					[024]
		0a																		\					[010]
	else																		\ (0xf)				[013 0b2]
		80																		\					[010]
		or																		\					[024]
		8																		\					[010]
	then																		\					[0b2]
	nvram-send-start-bit														\					[88c]
	nvram-send-address															\					[88d]
	28																			\					[010]
	dup																			\					[047]
	seectl!																		\					[847]
	nvram-delay																	\					[88b]
	0																			\					[0a5]
	10																			\					[010]
	0																			\					[0a5]
	do																			\ (0x27)			[017]
		2*																		\					[059]
		2c																		\					[010]
		dup																		\					[047]
		seectl!																	\					[847]
		nvram-delay																\					[88b]
		28																		\					[010]
		seectl!																	\					[847]
		seectl@																	\					[846]
		1																		\					[010]
		and																		\					[023]
		or																		\					[024]
		28																		\					[010]
		nvram-delay																\					[88b]
	loop																		\ (0xffdd)			[015]
	20																			\					[010]
	dup																			\					[047]
	seectl!																		\					[847]
	nvram-delay																	\					[88b]
	;																			\					[0c2]


: multifunction?																\ (88f)				[0b6 0b7]
	0e																			\					[010]
	my-b@																		\					[814]
	80																			\					[010]
	and																			\					[023]
	;																			\					[0c2]


: calc-nvram-base-address														\ (890)				[0b6 0b7]
	" ADPT,nvram-shared"														\					[012]
	get-my-property																\					[21a]
	if																			\ (0x7)				[014]
		0																		\					[0a5]
	else																		\ (0x41)			[013 0b2]
		2drop																	\					[052]
		multifunction?															\					[88f]
		if																		\ (0x1c)			[014]
			my-space															\					[103]
			700																	\					[010]
			and																	\					[023]
			if																	\ (0xb)				[014]
				40																\					[010]
			else																\ (0x5)				[013 0b2]
				0																\					[0a5]
			then																\					[0b2]
		else																	\ (0x20)			[013 0b2]
			my-space															\					[103]
			0f800																\					[010]
			and																	\					[023]
			2000																\					[010]
			=																	\					[03c]
			if																	\ (0x7)				[014]
				0																\					[0a5]
			else																\ (0x9)				[013 0b2]
				40																\					[010]
			then																\					[0b2]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]


: read-nvram																	\ (891)				[0b6 0b7]
	nvram-on																	\					[888]
	get-nvram-type																\					[88a]
	calc-nvram-base-address														\					[890]
	2/																			\					[057]
	/nvram-size																	\					[882]
	2/																			\					[057]
	0																			\					[0a5]
	do																			\ (0x15)			[017]
		dup																		\					[047]
		i																		\					[019]
		+																		\					[01e]
		nvram-read-register														\					[88e]
		wbsplit																	\					[0af]
		i																		\					[019]
		2*																		\					[059]
		dup																		\					[047]
		1+																		\					[0a6 01e]
		-rot																	\					[04b]
		nvram!																	\					[887]
		nvram!																	\					[887]
	loop																		\ (0xffef)			[015]
	drop																		\					[046]
	nvram-off																	\					[889]
	nvram-buffer																\					[883]
	/nvram-size																	\					[882]
	encode-bytes																\					[115]
	" ADPT,nvram"																\					[012]
	property																	\					[110]
	0																			\					[0a5]
	/nvram-size																	\					[882]
	0																			\					[0a5]
	do																			\ (0x9)				[017]
		i																		\					[019]
		nvram@																	\					[886]
		+																		\					[01e]
	loop																		\ (0xfffb)			[015]
	dup																			\					[047]
	0=																			\					[034]
	swap																		\					[049]
	3fc0																		\					[010]
	=																			\					[03c]
	or																			\					[024]
	if																			\ (0x1a)			[014]
		0																		\					[0a5]
		to nvram-valid															\					[0c3 885]
		" NVRAM is blank"														\					[012]
		warning																	\					[80f]
		exit																	\					[033]
	then																		\					[0b2]
	27																			\					[010]
	nvram@																		\					[886]
	#targets																	\					[80a]
	<>																			\					[03d]
	if																			\ (0x24)			[014]
		0																		\					[0a5]
		to nvram-valid															\					[0c3 885]
		" NVRAM target count wrong"												\					[012]
		warning																	\					[80f]
		exit																	\					[033]
	then																		\					[0b2]
	0																			\					[0a5]
	/nvram-size																	\					[882]
	2/																			\					[057]
	1-																			\					[0a6 01f]
	0																			\					[0a5]
	do																			\ (0x11)			[017]
		i																		\					[019]
		2*																		\					[059]
		dup																		\					[047]
		1+																		\					[0a6 01e]
		nvram@																	\					[886]
		swap																	\					[049]
		nvram@																	\					[886]
		bwjoin																	\					[0b0]
		+																		\					[01e]
	loop																		\ (0xfff3)			[015]
	0ffff																		\					[010]
	and																			\					[023]
	3f																			\					[010]
	nvram@																		\					[886]
	3e																			\					[010]
	nvram@																		\					[886]
	bwjoin																		\					[0b0]
	<>																			\					[03d]
	if																			\ (0x20)			[014]
		0																		\					[0a5]
		to nvram-valid															\					[0c3 885]
		" NVRAM checksum error"													\					[012]
		warning																	\					[80f]
		exit																	\					[033]
	then																		\					[0b2]
	1																			\					[0a6]
	to nvram-valid																\					[0c3 885]
	;																			\					[0c2]


: nvram-get-host-id																\ (892)				[0b6 0b7]
	nvram-valid																	\					[885]
	if																			\ (0x13)			[014]
		25																		\					[010]
		nvram@																	\					[886]
		0f																		\					[010]
		and																		\					[023]
	else																		\ (0x9)				[013 0b2]
		7																		\					[010]
	then																		\					[0b2]
	;																			\					[0c2]


: nvram-get-termination															\ (893)				[0b6 0b7]
	nvram-valid																	\					[885]
	0=																			\					[034]
	if																			\ (0x9)				[014]
		0																		\					[010]
		exit																	\					[033]
	then																		\					[0b2]
	23																			\					[010]
	nvram@																		\					[886]
	dup																			\					[047]
	1																			\					[010]
	and																			\					[023]
	if																			\ (0xb)				[014]
		3																		\					[010]
	else																		\ (0x31)			[013 0b2]
		dup																		\					[047]
		4																		\					[010]
		and																		\					[023]
		if																		\ (0xb)				[014]
			0																	\					[010]
		else																	\ (0x1d)			[013 0b2]
			dup																	\					[047]
			8																	\					[010]
			and																	\					[023]
			if																	\ (0xb)				[014]
				2																\					[010]
			else																\ (0x9)				[013 0b2]
				1																\					[010]
			then																\					[0b2]
		then																	\					[0b2]
	then																		\					[0b2]
	nip																			\					[04d]
	789x?																		\					[808]
	if																			\ (0x59)			[014]
		subsysid@																\					[816]
		80																		\					[010]
		and																		\					[023]
		if																		\ (0x4d)			[014]
			22																	\					[010]
			nvram@																\					[886]
			dup																	\					[047]
			4																	\					[010]
			and																	\					[023]
			if																	\ (0xb)				[014]
				30																\					[010]
			else																\ (0x31)			[013 0b2]
				dup																\					[047]
				8																\					[010]
				and																\					[023]
				if																\ (0xb)				[014]
					0															\					[010]
				else															\ (0x1d)			[013 0b2]
					dup															\					[047]
					10															\					[010]
					and															\					[023]
					if															\ (0xb)				[014]
						20														\					[010]
					else														\ (0x9)				[013 0b2]
						10														\					[010]
					then														\					[0b2]
				then															\					[0b2]
			then																\					[0b2]
			nip																	\					[04d]
			or																	\					[024]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]


: nvram-get-stpwlevel															\ (894)				[0b6 0b7]
	nvram-valid																	\					[885]
	0=																			\					[034]
	if																			\ (0xe)				[014]
		devconfig@																\					[850]
		2																		\					[010]
		or																		\					[024]
		devconfig!																\					[851]
		exit																	\					[033]
	then																		\					[0b2]
	21																			\					[010]
	nvram@																		\					[886]
	10																			\					[010]
	and																			\					[023]
	0<>																			\					[035]
	if																			\ (0x10)			[014]
		devconfig@																\					[850]
		2																		\					[010]
		or																		\					[024]
		devconfig!																\					[851]
	else																		\ (0xf)				[013 0b2]
		devconfig@																\					[850]
		2																		\					[010]
		invert																	\					[026]
		and																		\					[023]
		devconfig!																\					[851]
	then																		\					[0b2]
	;																			\					[0c2]


: qinfifo@																		\ (895)				[0b6 0b7]
	9b																			\					[010]
	mem-b@																		\					[823]
	;																			\					[0c2]


: qinfifo!																		\ (896)				[0b6 0b7]
	9b																			\					[010]
	mem-b!																		\					[824]
	;																			\					[0c2]


: pause																			\ (897)				[0b6 0b7]
	hcntrl@																		\					[857]
	4																			\					[010]
	or																			\					[024]
	hcntrl!																		\					[858]
	begin																		\					[0b1]
		hcntrl@																	\					[857]
		4																		\					[010]
		and																		\					[023]
	until																		\ (0xfff7)			[014]
	;																			\					[0c2]


: unpause																		\ (898)				[0b6 0b7]
	hcntrl@																		\					[857]
	4																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	hcntrl!																		\					[858]
	;																			\					[0c2]


: clear-scratch																	\ (899)				[0b6 0b7]
	40																			\					[010]
	0																			\					[0a5]
	do																			\ (0x9)				[017]
		0																		\					[0a5]
		i																		\					[019]
		scratch!																\					[84b]
	loop																		\ (0xfffb)			[015]
	;																			\					[0c2]


: cmd-cntrl@																	\ (89a)				[0b6 0b7]
	3e																			\					[010]
	scratch@																	\					[84a]
	;																			\					[0c2]


: cmd-cntrl!																	\ (89b)				[0b6 0b7]
	3e																			\					[010]
	scratch!																	\					[84b]
	;																			\					[0c2]


: set-break																		\ (89c)				[0b6 0b7]
	cmd-cntrl@																	\					[89a]
	4																			\					[010]
	or																			\					[024]
	cmd-cntrl!																	\					[89b]
	;																			\					[0c2]


: set-qin																		\ (89d)				[0b6 0b7]
	cmd-cntrl@																	\					[89a]
	2																			\					[0a7]
	or																			\					[024]
	cmd-cntrl!																	\					[89b]
	;																			\					[0c2]


: clear-scbs																	\ (89e)				[0b6 0b7]
	3																			\					[0a8]
	0																			\					[0a5]
	do																			\ (0x18)			[017]
		i																		\					[019]
		scbptr!																	\					[865]
		20																		\					[010]
		0																		\					[0a5]
		do																		\ (0x9)				[017]
			0																	\					[0a5]
			i																	\					[019]
			scbram!																\					[86c]
		loop																	\ (0xfffb)			[015]
	loop																		\ (0xffec)			[015]
	0																			\					[0a5]
	scbptr!																		\					[865]
	;																			\					[0c2]


: $c,																			\ (89f)				[0b6 0b7]
	bounds																		\					[0ac]
	?do																			\ (0x8)				[018]
		i																		\					[019]
		c@																		\					[071]
		c,																		\					[0d0]
	loop																		\ (0xfffc)			[015]
	;																			\					[0c2]

create sequencer-code															\ (8a0)				[0b6 0bb]
" "(0065 0EC0 0065 80C0 0065 9C40 0065 CA40 0065 9842 5A6A 0080 F711 2288 006A 2009)" \ ".e..e.e@.e@.eBZj..".j ."	\					[012]
$c,																				\					[89f]
" "(013B 78B0 400B 7468 200B 2CE8 4000 00E8 C05E 2278 025E 2A78 006A 2009 FD5E BC88)" \ ".;x@.th .,@..^"x.^*x.j .^"	\					[012]
$c,																				\					[89f]
" "(0065 26C0 019C 2AF8 019B 20B1 0190 7830 0065 6040 0065 0040 FF6A 7880 086A 1800)" \ ".e&.*. .x0.e`@.e.@.jx.j.."	\					[012]
$c,																				\					[89f]
" "(0811 2200 200B 0CF8 206A 1680 0065 74DA E064 40F0 A064 88E2 216A 2201 0065 3640)" \ "..". .. j..etd@d!j"..e6@"	\					[012]
$c,																				\					[89f]
" "(8012 0E7A 0F12 C888 0019 7400 01A0 C8B0 006A 6888 0134 78B0 FBA1 4289 003A FCD9)" \ "..z..Ȉ..t..Ȱ.jh.4xB.:"	\					[012]
$c,																				\					[89f]
" "(0065 72DA E064 5670 0065 58C0 8012 50E8 FFA2 5CE8 016A 4481 FFB7 9CF8 01B7 0071)" \ ".erdVp.eX.P.\.jD...q"	\					[012]
$c,																				\					[89f]
" "(013C 76B0 F0A0 C888 405E AAEA 0F05 0A08 0005 0A80 006A 2609 1801 0280 206A 1800)" \ ".<vȈ@^........j&.... j.."	\					[012]
$c,																				\					[89f]
" "(5A6A 0080 400B 00F8 01A3 66B1 086A 1800 126A 0080 0811 2200 400B 0AF8 406A 1680)" \ "Zj.@...f.j...j...".@..@j."	\					[012]
$c,																				\					[89f]
" "(0065 74DA 405E 3EEB A064 AC60 0FA0 7208 40A1 90F8 326A F4D9 006E 90E8 4039 7200)" \ ".et@^>d`.r.@2j.n@9r."	\					[012]
$c,																				\					[89f]
" "(8039 7400 013A 7230 00A0 FE59 8F3A 9AF0 406A 1800 0139 0C30 0065 74DA 8064 B270)" \ "9t..:r0.Y:@j...9.0.etڀdp"	\					[012]
$c,																				\					[89f]
" "(E064 A8F0 C064 52F1 A064 88E2 016A 2281 006A A6D9 0065 9C40 406A 1800 C064 52F1)" \ "ddRd.j".j.e@@j..dR"	\					[012]
$c,																				\					[89f]
" "(8064 8862 406A 1800 00A0 FCD9 8F3A A6F0 01A2 72B0 A86A A2DA 405E C0EA 01A2 1030)" \ "db@j...ُ:.rj@^..0"	\					[012]
$c,																				\					[89f]
" "(3D6A 2601 040B D0E8 100C C2F8 040B D0E8 006A 2609 0065 74DA C064 52F1 116A 2201)" \ "=j&........j&..etdR.j"."	\					[012]
$c,																				\					[89f]
" "(405E EC6A 346A CC00 A36A 12DA 0065 24DA B86A CC80 886A 105A 01A1 C830 0164 6C31)" \ "@^j4j.j..e$ڸj̀j.Z.0.dl1"	\					[012]
$c,																				\					[89f]
" "(A36A CC80 346A 125A 0065 12C1 0493 EC68 405E F86A 0194 EA78 1094 ECE8 C793 2689)" \ "j̀4j.Z.e..h@^j.x.Ǔ&"	\					[012]
$c,																				\					[89f]
" "(C05E F468 0199 D430 0893 F0E8 B06A CC00 086A 16DA 0134 6631 405E 0A6B 0065 7EDA)" \ "^h.0.j..j..4f1@^.k.e~"	\					[012]
$c,																				\					[89f]
" "(346A CC00 A36A 12DA 886A CC80 B86A 105A 405E 12E9 086A CC00 8C6A 16DA 01B6 C830)" \ "4j.j.ڈj̀j.Z@^..j.j..0"	\					[012]
$c,																				\					[89f]
" "(0164 4231 FFBC 1AE9 FFBD 1A69 FFBE 1A69 FFA3 4CF9 0065 7EDA 405E 186B 396A 7280)" \ ".dB1....i..i.L.e~@^.k9jr"	\					[012]
$c,																				\					[89f]
" "(4003 2469 3D6A 7200 BF39 7288 10A1 2A69 FF34 2C79 4039 7200 0139 2631 006A 4489)" \ "@.$i=jr.9r.*i.4,y@9r..9&1.jD"	\					[012]
$c,																				\					[89f]
" "(100C E668 010B 3079 8004 3A79 010C 36F9 100C EEE8 10A1 3E69 FF34 4679 0065 24DA)" \ "..h..0y.:y..6...>i.4Fy.e$"	\					[012]
$c,																				\					[89f]
" "(0065 24C1 016A A659 0065 00C1 B06A CC00 0065 1EDA C793 2689 0065 7EDA 316A 2281)" \ ".e$.jY.e.j..e.Ǔ&.e~1j""	\					[012]
$c,																				\					[89f]
" "(0065 4C41 FFB0 7469 FFB1 74E9 FFB2 74E9 FFB3 7469 0106 7430 0065 74DA E064 8862)" \ ".eLA.ti.t.t.ti..t0.etdb"	\					[012]
$c,																				\					[89f]
" "(FF12 64F9 416A 2201 FF3A 1C6A 0065 8A5A C05E 6EE9 0190 3AB1 0065 7041 015E BC00)" \ "..dAj"..:.j.eZ^n.:.epA.^."	\					[012]
$c,																				\					[89f]
" "(026A 2281 0065 0040 346A CC00 A36A 12DA 0134 C830 0164 C818 00B3 84E1 006A 6689)" \ ".j".e.@4j.j..40.d...jf"	\					[012]
$c,																				\					[89f]
" "(0065 90C1 0065 24DA 0134 C830 00B3 82E1 006A 6689 10A1 8EE9 FF34 A279 0065 24DA)" \ ".e.e$.40..jf..4y.e$"	\					[012]
$c,																				\					[89f]
" "(0108 C830 00B0 6099 0109 C8B0 00B1 6221 010A C8B0 00B2 6421 01B3 C830 006A 66A1)" \ "..0.`..Ȱ.b!..Ȱ.d!.0.jf"	\					[012]
$c,																				\					[89f]
" "(0065 8A41 316A 2281 0065 5AC1 0165 6E31 0212 B471 0412 CA71 0112 D6F1 0312 EEF1)" \ ".eA1j".eZ.en1..q..q...."	\					[012]
$c,																				\					[89f]
" "(0812 ECF1 416A 2285 FFA2 C4E9 A36A CC80 346A 125A B86A CC80 146A 14DA B06A 16DA)" \ "..Aj".j̀4j.Zj̀.j.ڰj."	\					[012]
$c,																				\					[89f]
" "(01A1 C830 0164 6C31 0106 D430 405E FEE8 0065 1A41 40A1 B279 326A F4D9 006E B269)" \ ".0.dl1..0@^.e.A@y2j.ni"	\					[012]
$c,																				\					[89f]
" "(04A1 4201 0065 8A5A 0065 0040 0065 72DA E064 9662 0112 7430 0065 72DA E064 9662)" \ ".B..eZ.e.@.erdb..t0.erdb"	\					[012]
$c,																				\					[89f]
" "(053A E861 FF12 E8E9 416A 2201 0065 C441 716A 2201 FF6A D420 0106 D4B4 0065 72DA)" \ ".:a..Aj"..eAqj"..j ..Դ.er"	\					[012]
$c,																				\					[89f]
" "(8064 B270 FF6A D48C 80A0 F879 0165 CA18 01A0 DCB0 016C C834 1A01 0200 405E B06A)" \ "dp.jԌy.e..ܰ.l4....@^j"	\					[012]
$c,																				\					[89f]
" "(4C65 CA28 2065 CA18 016C 7430 306A F459 006E 0CFA 2001 0200 013A 0834 916A 2281)" \ "Le( e..lt00jY.n. ....:.4j""	\					[012]
$c,																				\					[89f]
" "(0065 18DA 016C DAB0 016C DAB0 016C DAB0 016C DAB0 016C DA34 516A 2281 0065 205A)" \ ".e..lڰ.lڰ.lڰ.lڰ.l4Qj".e Z"	\					[012]
$c,																				\					[89f]
" "(006A DA88 006A DA0C 405E C6EA C793 2689 3893 286A 10A1 38FA EFA1 4289 886A CC80)" \ ".jڈ.j.@^Ǔ&8(j.8Bj̀"	\					[012]
$c,																				\					[89f]
" "(886A 14DA 046A DA80 0065 205A 0065 6E42 886A CC80 356A 14DA 086A DA80 0065 205A)" \ "j..jڀ.e Z.enBj̀5j..jڀ.e Z"	\					[012]
$c,																				\					[89f]
" "(0D93 2601 0894 427A F793 2689 356A CC80 886A 14DA FF34 6898 886A CC80 0199 DAB0)" \ ".&..Bz&5j̀j..4hj̀.ڰ"	\					[012]
$c,																				\					[89f]
" "(8F66 4EE2 018C C830 0088 7498 033A 6EFA 043A 6E7A 083A 6E7A FF8E 66EA FF8D 66EA)" \ "fN.0.t.:n.:nz.:nz.f.f"	\					[012]
$c,																				\					[89f]
" "(F36A C800 008C 7418 0065 6ED2 FC8C 1899 FF8D 1A21 FF8E 1C21 10A1 4201 086A CC00)" \ "j..t..en...!..!.B..j."	\					[012]
$c,																				\					[89f]
" "(8C6A 16C2 0106 D430 010C 74FA 040C 746A E003 0688 E003 C88C 216A 2201 0065 74DA)" \ "j...0..t..tj...Ȍ!j"..et"	\					[012]
$c,																				\					[89f]
" "(A064 96FA E064 42F1 C064 52F1 A064 7CF2 616A 2281 006A 0888 DF01 0288 F711 2288)" \ "ddBdRd|aj".j....""	\					[012]
$c,																				\					[89f]
" "(0106 D430 090C 92FA 080C 88FA FF6A D48C FFB0 6099 FFB0 98EA FFB1 6299 FFB1 98E2)" \ "..0.....jԌ.`..b."	\					[012]
$c,																				\					[89f]
" "(016A 2281 886A CC80 0065 14DA 0139 DAB0 0065 2042 0F0F 1E08 000F 1E80 0065 6A40)" \ ".j"j̀.e..9ڰ.e B........ej@"	\					[012]
$c,																				\					[89f]
" "(4C65 CA28 0165 C8B0 2065 CA18 016C 7430 013A 08B0 0164 CAB0 7065 CA18 016C 0AB4)" \ "Le(.eȰ e..lt0.:..dʰpe..l."	\					[012]
$c,																				\					[89f]
" "(026A F801 AC6A 2681 0065 C2C0 D793 2609 2893 C86A 0065 74DA E003 C808 C064 D662)" \ ".j.j&.eד&.(j.et..db"	\					[012]
$c,																				\					[89f]
" "(0065 DC5A 04EA D419 03E9 1034 0065 DC5A 07E9 10B1 FF6A D48C 0435 C0B1 086A D001)" \ ".eZ....4.eZ...jԌ.5.j."	\					[012]
$c,																				\					[89f]
" "(006A DE89 096A D681 80EB E4FA 016A D601 04E0 6AB0 FF34 681C 05A3 6830 0065 C6DA)" \ ".jމ.jց.j..j.4h..h0.e"	\					[012]
$c,																				\					[89f]
" "(006A D489 07E9 70B1 0534 4631 0065 12C1 DF93 2689 2093 FA6A 0293 2601 0194 FC7A)" \ ".jԉ.p.4F1.e.ߓ& j.&..z"	\					[012]
$c,																				\					[89f]
" "(0194 FC7A 0194 FC7A 0194 FC7A 0194 FC7A 0065 ECC0 1201 0280 040C 10FB 0065 7EDA)" \ ".z.z.z.z.e.......e~"	\					[012]
$c,																				\					[89f]
" "(E003 C808 E003 0688 0065 805A 0065 00C1 A86A 7200 4003 1EEB AC6A 7280 006A F809)" \ ".....eZ.e.jr.@..jr.j."	\					[012]
$c,																				\					[89f]
" "(FF34 24EB 026A F801 0139 2631 006A 4489 100C E668 010B 28FB FF34 4679 8004 347B)" \ ".4$.j..9&1.jD..h..(.4Fy.4{"	\					[012]
$c,																				\					[89f]
" "(010C 307B 100C EEE8 0065 D65A 0065 1E43 046C C0B1 0139 D031 006A DE0D 045E 84F8)" \ "..0{...eZ.e.C.l.91.j..^"	\					[012]
$c,																				\					[89f]
" "(B16A 2201 0065 8440)" \ "j"..e@"											\					[012]
$c,																				\					[89f]
here																			\					[0ad]
sequencer-code																	\					[8a0]
-																				\					[01f]
constant /sequencer-code														\ (8a1)				[0b6 0ba]

: init-sequencer																\ (8a2)				[0b6 0b7]
	81																			\					[010]
	seq-ctl!																	\					[84d]
	;																			\					[0c2]


: reset-sequencer																\ (8a3)				[0b6 0b7]
	80																			\					[010]
	seq-ctl!																	\					[84d]
	;																			\					[0c2]


: (code@)																		\ (8a4)				[0b6 0b7]
	>r																			\					[030]
	r@																			\					[032]
	c@																			\					[071]
	r@																			\					[032]
	1+																			\					[0a6 01e]
	c@																			\					[071]
	r@																			\					[032]
	2+																			\					[0a7 01e]
	c@																			\					[071]
	r>																			\					[031]
	3																			\					[0a8]
	+																			\					[01e]
	c@																			\					[071]
	bljoin																		\					[07f]
	;																			\					[0c2]

defer code@																		\ (8a5)				[0b6 0bc]
['] (code@)																		\					[011 8a4]
to code@																		\					[0c3 8a5]

: load-sequencer																\ (8a6)				[0b6 0b7]
	0																			\					[0a5]
	seq-addr!																	\					[855]
	sequencer-code																\					[8a0]
	/sequencer-code																\					[8a1]
	bounds																		\					[0ac]
	do																			\ (0xf)				[017]
		i																		\					[019]
		code@																	\					[8a5]
		seq-data!																\					[853]
		4																		\					[010]
	+loop																		\ (0xfff5)			[016]
	;																			\					[0c2]


: verify-sequencer																\ (8a7)				[0b6 0b7]
	0																			\					[0a5]
	seq-addr!																	\					[855]
	sequencer-code																\					[8a0]
	/sequencer-code																\					[8a1]
	bounds																		\					[0ac]
	do																			\ (0x26)			[017]
		i																		\					[019]
		code@																	\					[8a5]
		seq-data@																\					[852]
		<>																		\					[03d]
		if																		\ (0x15)			[014]
			debug?																\					[80d]
			if																	\ (0xc)				[014]
				cr																\					[092]
				i																\					[019]
				sequencer-code													\					[8a0]
				-																\					[01f]
				u.																\					[09b]
				seq-addr@														\					[854]
				u.																\					[09b]
			then																\					[0b2]
			unloop																\					[089]
			-1																	\					[0a4]
			exit																\					[033]
		then																	\					[0b2]
		4																		\					[010]
	+loop																		\ (0xffde)			[016]
	0																			\					[0a5]
	;																			\					[0c2]


: download-sequencer															\ (8a8)				[0b6 0b7]
	init-sequencer																\					[8a2]
	load-sequencer																\					[8a6]
	reset-sequencer																\					[8a3]
	init-sequencer																\					[8a2]
	verify-sequencer															\					[8a7]
	reset-sequencer																\					[8a3]
	;																			\					[0c2]


: 60-code@																		\ (8a9)				[0b6 0b7]
	(code@)																		\					[8a4]
	>r																			\					[030]
	r@																			\					[032]
	0ffff																		\					[010]
	and																			\					[023]
	r@																			\					[032]
	3fe0000																		\					[010]
	and																			\					[023]
	1																			\					[0a6]
	rshift																		\					[028]
	r@																			\					[032]
	78000000																	\					[010]
	and																			\					[023]
	dup																			\					[047]
	1b																			\					[010]
	rshift																		\					[028]
	8																			\					[010]
	<																			\					[03a]
	if																			\ (0x36)			[014]
		r@																		\					[032]
		4000000																	\					[010]
		and																		\					[023]
		2																		\					[0a7]
		rshift																	\					[028]
		rot																		\					[04a]
		0feffffff																\					[010]
		and																		\					[023]
		or																		\					[024]
		swap																	\					[049]
		dup																		\					[047]
		1b																		\					[010]
		rshift																	\					[028]
		6																		\					[010]
		=																		\					[03c]
		if																		\ (0x13)			[014]
			drop																\					[046]
			1																	\					[0a6]
			1b																	\					[010]
			lshift																\					[027]
			rot																	\					[04a]
			0ff																	\					[010]
			or																	\					[024]
			-rot																\					[04b]
		then																	\					[0b2]
	then																		\					[0b2]
	2																			\					[0a7]
	rshift																		\					[028]
	or																			\					[024]
	or																			\					[024]
	r>																			\					[031]
	drop																		\					[046]
	;																			\					[0c2]

['] 60-code@																	\					[011 8a9]
to code@																		\					[0c3 8a5]

: send-scb																		\ (8aa)				[0b6 0b7]
	scbptr@																		\					[864]
	0																			\					[0a5]
	scbcnt!																		\					[86a]
	0																			\					[0a5]
	scbptr!																		\					[865]
	80																			\					[010]
	scbcnt!																		\					[86a]
	/scb																		\					[87d]
	0																			\					[0a5]
	do																			\ (0xd)				[017]
		scb																		\					[87c]
		i																		\					[019]
		+																		\					[01e]
		c@																		\					[071]
		0																		\					[0a5]
		scbram!																	\					[86c]
	loop																		\ (0xfff7)			[015]
	0																			\					[0a5]
	scbcnt!																		\					[86a]
	0																			\					[0a5]
	qinfifo!																	\					[896]
	scbptr!																		\					[865]
	;																			\					[0c2]


: cable-sense																	\ (8ab)				[0b6 0b7]
	seectl@																		\					[846]
	20																			\					[010]
	seectl!																		\					[847]
	brdctl@																		\					[844]
	0c																			\					[010]
	or																			\					[024]
	1																			\					[0a6]
	ms																			\					[126]
	brdctl!																		\					[845]
	seectl@																		\					[846]
	dup																			\					[047]
	20																			\					[010]
	or																			\					[024]
	seectl!																		\					[847]
	1																			\					[0a6]
	ms																			\					[126]
	20																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	seectl!																		\					[847]
	brdctl@																		\					[844]
	60																			\					[010]
	and																			\					[023]
	60																			\					[010]
	=																			\					[03c]
	if																			\ (0x7)				[014]
		1																		\					[0a6]
	else																		\ (0x5)				[013 0b2]
		0																		\					[0a5]
	then																		\					[0b2]
	swap																		\					[049]
	seectl!																		\					[847]
	;																			\					[0c2]


: select-termination															\ (8ac)				[0b6 0b7]
	0f																			\					[010]
	and																			\					[023]
	dup																			\					[047]
	3																			\					[0a8]
	=																			\					[03c]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		cable-sense																\					[8ab]
	then																		\					[0b2]
	1																			\					[0a6]
	=																			\					[03c]
	if																			\ (0xd)				[014]
		sxfrctl1@																\					[82f]
		1																		\					[0a6]
		invert																	\					[026]
		and																		\					[023]
		sxfrctl1!																\					[830]
	else																		\ (0xa)				[013 0b2]
		sxfrctl1@																\					[82f]
		1																		\					[0a6]
		or																		\					[024]
		sxfrctl1!																\					[830]
	then																		\					[0b2]
	;																			\					[0c2]


: wait-for-bus-stable															\ (8ad)				[0b6 0b7]
	789x?																		\					[808]
	if																			\ (0x1e)			[014]
		get-msecs																\					[125]
		400																		\					[010]
		+																		\					[01e]
		begin																	\					[0b1]
			dup																	\					[047]
			get-msecs															\					[125]
			<																	\					[03a]
			sblkctl@															\					[848]
			0c																	\					[010]
			and																	\					[023]
			0<>																	\					[035]
			or																	\					[024]
		until																	\ (0xfff1)			[014]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]

0 value simode																	\ (8ae 0)			[0a5 0b6 0b8]

: reset-bus																		\ (8af)				[0b6 0b7]
	simode0@																	\					[840]
	to simode																	\					[0c3 8ae]
	0																			\					[0a5]
	simode0!																	\					[841]
	0																			\					[0a5]
	simode1!																	\					[843]
	0f																			\					[010]
	clrint!																		\					[868]
	wait-for-bus-stable															\					[8ad]
	1																			\					[010]
	scsiseq!																	\					[82c]
	0f																			\					[010]
	clrint!																		\					[868]
	1																			\					[0a6]
	ms																			\					[126]
	0																			\					[0a5]
	scsiseq!																	\					[82c]
	20																			\					[010]
	scsi-int1!																	\					[839]
	scsi-stat1@																	\					[83a]
	0ff																			\					[010]
	scsi-int0!																	\					[837]
	10																			\					[010]
	invert																		\					[026]
	and																			\					[023]
	scsi-int1!																	\					[839]
	5																			\					[010]
	clrint!																		\					[868]
	40																			\					[010]
	ms																			\					[126]
	simode																		\					[8ae]
	simode0!																	\					[841]
	0a4																			\					[010]
	simode1!																	\					[843]
	0																			\					[0a5]
	seq-addr!																	\					[855]
	;																			\					[0c2]


: reset-channel																	\ (8b0)				[0b6 0b7]
	0																			\					[0a5]
	scsiseq!																	\					[82c]
	0ff																			\					[010]
	scsi-int0!																	\					[837]
	0ff																			\					[010]
	scsi-int1!																	\					[839]
	12																			\					[010]
	sxfrctl0!																	\					[82e]
	27																			\					[010]
	sxfrctl1!																	\					[830]
	begin																		\					[0b1]
		dfcntrl@																\					[85e]
		8																		\					[010]
		and																		\					[023]
		while																	\ (0xd)				[014]
			0																	\					[010]
			dfcntrl!															\					[85f]
	repeat																		\ (0xffed)			[013 0b2]
	1																			\					[010]
	dfcntrl!																	\					[85f]
	0a4																			\					[010]
	simode1!																	\					[843]
	789x?																		\					[808]
	if																			\ (0xa)				[014]
		8																		\					[010]
		simode0!																\					[841]
	then																		\					[0b2]
	0																			\					[010]
	scbptr!																		\					[865]
	;																			\					[0c2]


: wait-for-int																	\ (8b1)				[0b6 0b7]
	begin																		\					[0b1]
		intstat@																\					[866]
		0f																		\					[010]
		and																		\					[023]
	until																		\ (0xfff7)			[014]
	;																			\					[0c2]

0 value hw-status																\ (8b2 0)			[0a5 0b6 0b8]
0 value hw-error																\ (8b3 0)			[0a5 0b6 0b8]

: handle-command-complete														\ (8b4)				[0b6 0b7]
	789x?																		\					[808]
	if																			\ (0x29)			[014]
		cmd-cntrl@																\					[89a]
		1																		\					[010]
		and																		\					[023]
		if																		\ (0x1a)			[014]
			cmd-cntrl@															\					[89a]
			0fe																	\					[010]
			and																	\					[023]
			cmd-cntrl!															\					[89b]
			2																	\					[0a7]
			clrint!																\					[868]
			0c																	\					[010]
			scbram@																\					[86b]
			to hw-status														\					[0c3 8b2]
		then																	\					[0b2]
	else																		\ (0x11)			[013 0b2]
		2																		\					[0a7]
		clrint!																	\					[868]
		0c																		\					[010]
		scbram@																	\					[86b]
		to hw-status															\					[0c3 8b2]
	then																		\					[0b2]
	;																			\					[0c2]


: handle-scsi-ints																\ (8b5)				[0b6 0b7]
	scsi-stat0@																	\					[838]
	8																			\					[010]
	and																			\					[023]
	if																			\ (0x18)			[014]
		8																		\					[010]
		scsi-int0!																\					[837]
		reset-bus																\					[8af]
		reset-channel															\					[8b0]
		99																		\					[010]
		to hw-error																\					[0c3 8b3]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	scsi-stat1@																	\					[83a]
	20																			\					[010]
	and																			\					[023]
	if																			\ (0x40)			[014]
		get-msecs																\					[125]
		1000																	\					[010]
		+																		\					[01e]
		begin																	\					[0b1]
			dup																	\					[047]
			get-msecs															\					[125]
			<																	\					[03a]
			20																	\					[010]
			scsi-int1!															\					[839]
			scsi-stat1@															\					[83a]
			20																	\					[010]
			and																	\					[023]
			0=																	\					[034]
			or																	\					[024]
		until																	\ (0xffea)			[014]
		drop																	\					[046]
		0																		\					[0a5]
		scsiseq!																\					[82c]
		scsisig@																\					[831]
		0<>																		\					[035]
		if																		\ (0x5)				[014]
			reset-bus															\					[8af]
		then																	\					[0b2]
		reset-channel															\					[8b0]
		0																		\					[0a5]
		seq-addr!																\					[855]
		99																		\					[010]
		to hw-error																\					[0c3 8b3]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	scsi-stat1@																	\					[83a]
	80																			\					[010]
	and																			\					[023]
	if																			\ (0x22)			[014]
		scsiseq@																\					[82b]
		48																		\					[010]
		invert																	\					[026]
		and																		\					[023]
		scsiseq!																\					[82c]
		88																		\					[010]
		scsi-int1!																\					[839]
		10																		\					[010]
		scsi-int0!																\					[837]
		-1																		\					[0a4]
		to hw-error																\					[0c3 8b3]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	scsi-stat1@																	\					[83a]
	8																			\					[010]
	and																			\					[023]
	if																			\ (0x2f)			[014]
		1																		\					[010]
		dfcntrl!																\					[85f]
		sxfrctl0@																\					[82d]
		1a																		\					[010]
		or																		\					[024]
		sxfrctl0!																\					[82e]
		simode1@																\					[842]
		8																		\					[010]
		invert																	\					[026]
		and																		\					[023]
		simode1!																\					[843]
		8																		\					[010]
		scsi-int1!																\					[839]
		0																		\					[0a5]
		seq-addr!																\					[855]
		-1																		\					[0a4]
		to hw-error																\					[0c3 8b3]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	scsi-stat1@																	\					[83a]
	4																			\					[010]
	and																			\					[023]
	if																			\ (0x10)			[014]
		sxfrctl1@																\					[82f]
		20																		\					[010]
		invert																	\					[026]
		and																		\					[023]
		sxfrctl1!																\					[830]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	;																			\					[0c2]


: send-message-out																\ (8b6)				[0b6 0b7]
	0a0																			\					[010]
	3																			\					[010]
	mem-b!																		\					[824]
	3																			\					[010]
	mem-b@																		\					[823]
	10																			\					[010]
	and																			\					[023]
	if																			\ (0x28)			[014]
		." wanted extended message...barf"										\					[012 090]
		cr																		\					[092]
	else																		\ (0x22)			[013 0b2]
		8																		\					[010]
		6																		\					[010]
		mem-b!																	\					[824]
		begin																	\					[0b1]
			3																	\					[010]
			mem-b@																\					[823]
			1																	\					[010]
			and																	\					[023]
			0=																	\					[034]
		until																	\ (0xfff1)			[014]
	then																		\					[0b2]
	;																			\					[0c2]


: handle-sync-negotiate															\ (8b7)				[0b6 0b7]
	2																			\					[0a7]
	seq-addr!																	\					[855]
	3																			\					[0a8]
	mem-b@																		\					[823]
	0e0																			\					[010]
	and																			\					[023]
	0a0																			\					[010]
	<>																			\					[03d]
	if																			\ (0x9)				[014]
		0																		\					[0a5]
		his-id																	\					[878]
		scratch!																\					[84b]
		exit																	\					[033]
	then																		\					[0b2]
	his-id																		\					[878]
	scratch@																	\					[84a]
	8f																			\					[010]
	=																			\					[03c]
	if																			\ (0x8)				[014]
		0																		\					[0a5]
		his-id																	\					[878]
		scratch!																\					[84b]
	then																		\					[0b2]
	send-message-out															\					[8b6]
	;																			\					[0c2]


: handle-interrupt																\ (8b8)				[0b6 0b7]
	pause																		\					[897]
	intstat@																	\					[866]
	2																			\					[0a7]
	and																			\					[023]
	if																			\ (0x7)				[014]
		handle-command-complete													\					[8b4]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	intstat@																	\					[866]
	1																			\					[0a6]
	and																			\					[023]
	if																			\ (0x10c)			[014]
		1																		\					[0a6]
		clrint!																	\					[868]
		intstat@																\					[866]
		4																		\					[010]
		rshift																	\					[028]
		case																	\					[0c4]
			0																	\					[010]
			of																	\ (0x7)				[01c]
				handle-sync-negotiate											\					[8b7]
			endof																\ (0xee)			[0c6]
			2																	\					[010]
			of																	\ (0x58)			[01c]
				0a0																\					[010]
				scsisig!														\					[832]
				scsisig@														\					[831]
				10																\					[010]
				and																\					[023]
				if																\ (0x2e)			[014]
					sxfrctl1@													\					[82f]
					dup															\					[047]
					0df															\					[010]
					and															\					[023]
					sxfrctl1!													\					[830]
					20															\					[010]
					or															\					[024]
					sxfrctl1!													\					[830]
					44															\					[010]
					scsi-int1!													\					[839]
					4															\					[010]
					clrint!														\					[868]
					5															\					[010]
					scsidatl!													\					[836]
				else															\ (0xb)				[013 0b2]
					8															\					[010]
					scsidatl!													\					[836]
				then															\					[0b2]
				begin															\					[0b1]
					scsisig@													\					[831]
					1															\					[010]
					and															\					[023]
					0=															\					[034]
				until															\ (0xfff6)			[014]
			endof																\ (0x90)			[0c6]
			3																	\					[010]
			of																	\ (0x5)				[01c]
			endof																\ (0x85)			[0c6]
			5																	\					[010]
			of																	\ (0x2b)			[01c]
				sxfrctl0@														\					[82d]
				2																\					[010]
				or																\					[024]
				sxfrctl0!														\					[82e]
				simode1@														\					[842]
				8																\					[010]
				invert															\					[026]
				and																\					[023]
				simode1!														\					[843]
				6																\					[010]
				mem-b@															\					[823]
				drop															\					[046]
				0																\					[0a5]
				seq-addr!														\					[855]
				2																\					[0a7]
				to hw-status													\					[0c3 8b2]
				-1																\					[0a4]
				exit															\					[033]
			endof																\ (0x54)			[0c6]
			6																	\					[010]
			of																	\ (0xd)				[01c]
				reset-bus														\					[8af]
				-1																\					[0a4]
				to hw-error														\					[0c3 8b3]
				-1																\					[0a4]
				exit															\					[033]
			endof																\ (0x41)			[0c6]
			7																	\					[010]
			of																	\ (0x5)				[01c]
			endof																\ (0x36)			[0c6]
			." Unexpected Sequencer Interrupt: $"								\					[012 090]
			dup																	\					[047]
			.h																	\					[0a0 06d 049 010 0a0 072 09d 0a0 072]
			cr																	\					[092]
		endcase																	\					[0c5]
		unpause																	\					[898]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	intstat@																	\					[866]
	4																			\					[010]
	and																			\					[023]
	if																			\ (0x16)			[014]
		handle-scsi-ints														\					[8b5]
		4																		\					[010]
		clrint!																	\					[868]
		dup																		\					[047]
		if																		\ (0x7)				[014]
			-1																	\					[0a4]
			to hw-error															\					[0c3 8b3]
		then																	\					[0b2]
		exit																	\					[033]
	then																		\					[0b2]
	-1																			\					[0a4]
	exit																		\					[033]
	;																			\					[0c2]


: execute-command																\ (8b9)				[0b6 0b7]
	his-id																		\					[878]
	#targets																	\					[80a]
	>=																			\					[042]
	his-id																		\					[878]
	my-id																		\					[877]
	=																			\					[03c]
	or																			\					[024]
	if																			\ (0x8)				[014]
		3drop																	\					[046 052]
		2drop																	\					[052]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	pause																		\					[897]
	setup-scb																	\					[880]
	send-scb																	\					[8aa]
	789x?																		\					[808]
	if																			\ (0x5)				[014]
		set-qin																	\					[89d]
	then																		\					[0b2]
	0																			\					[0a5]
	to hw-status																\					[0c3 8b2]
	0																			\					[0a5]
	to hw-error																	\					[0c3 8b3]
	unpause																		\					[898]
	begin																		\					[0b1]
		wait-for-int															\					[8b1]
		handle-interrupt														\					[8b8]
	until																		\ (0xfffb)			[014]
	teardown-scb																\					[881]
	hw-error																	\					[8b3]
	?dup																		\					[050]
	if																			\ (0x4)				[014]
		exit																	\					[033]
	then																		\					[0b2]
	hw-status																	\					[8b2]
	0																			\					[0a5]
	;																			\					[0c2]


: close-hardware																\ (8ba)				[0b6 0b7]
	free-sg-list																\					[871]
	free-dummy																	\					[82a]
	unmap-mem-regs																\					[822]
	;																			\					[0c2]


: limit-scsi-id																	\ (8bb)				[0b6 0b7]
	dup																			\					[047]
	#targets																	\					[80a]
	>=																			\					[042]
	if																			\ (0x9)				[014]
		drop																	\					[046]
		7																		\					[010]
	then																		\					[0b2]
	;																			\					[0c2]

0 value stpwen																	\ (8bc 0)			[0a5 0b6 0b8]

: open-hardware																	\ (8bd)				[0b6 0b7]
	7899?																		\					[804]
	if																			\ (0x21)			[014]
		my-unit																	\					[20d]
		nip																		\					[04d]
		nip																		\					[04d]
		100																		\					[010]
		and																		\					[023]
		0=																		\					[034]
		if																		\ (0xa)				[014]
			-1																	\					[0a4]
			to channel-a														\					[0c3 80c]
		else																	\ (0x8)				[013 0b2]
			0																	\					[0a5]
			to channel-a														\					[0c3 80c]
		then																	\					[0b2]
	else																		\ (0x8)				[013 0b2]
		-1																		\					[0a4]
		to channel-a															\					[0c3 80c]
	then																		\					[0b2]
	map-mem-regs																\					[821]
	7892?																		\					[805]
	if																			\ (0xe)				[014]
		1																		\					[010]
		sxfrctl1@																\					[82f]
		and																		\					[023]
		to stpwen																\					[0c3 8bc]
	then																		\					[0b2]
	chip-reset																	\					[85b]
	pause																		\					[897]
	read-nvram																	\					[891]
	" scsi-initiator-id"														\					[012]
	get-inherited-property														\					[21d]
	if																			\ (0xc)				[014]
		nvram-get-host-id														\					[892]
		limit-scsi-id															\					[8bb]
		set-my-id																\					[87b]
	else																		\ (0x1c)			[013 0b2]
		decode-int																\					[21b]
		dup																		\					[047]
		#targets																\					[80a]
		<																		\					[03a]
		if																		\ (0x8)				[014]
			set-my-id															\					[87b]
		else																	\ (0xb)				[013 0b2]
			drop																\					[046]
			nvram-get-host-id													\					[892]
			limit-scsi-id														\					[8bb]
			set-my-id															\					[87b]
		then																	\					[0b2]
		2drop																	\					[052]
	then																		\					[0b2]
	clear-scbs																	\					[89e]
	clear-scratch																\					[899]
	789x?																		\					[808]
	if																			\ (0xb)				[014]
		40																		\					[010]
	else																		\ (0x9)				[013 0b2]
		0																		\					[010]
	then																		\					[0b2]
	cmd-cntrl!																	\					[89b]
	download-sequencer															\					[8a8]
	if																			\ (0x23)			[014]
		" Sequencer download failed!"											\					[012]
		warning																	\					[80f]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	7892?																		\					[805]
	if																			\ (0x3c)			[014]
		stpwen																	\					[8bc]
		0=																		\					[034]
		if																		\ (0x1b)			[014]
			1																	\					[010]
			sxfrctl1@															\					[82f]
			or																	\					[024]
			sxfrctl1!															\					[830]
			1																	\					[010]
			invert																\					[026]
			sxfrctl1@															\					[82f]
			and																	\					[023]
			sxfrctl1!															\					[830]
		else																	\ (0x1d)			[013 0b2]
			1																	\					[010]
			sxfrctl1@															\					[82f]
			and																	\					[023]
			stpwen																\					[8bc]
			<>																	\					[03d]
			if																	\ (0xd)				[014]
				1																\					[010]
				sxfrctl1@														\					[82f]
				or																\					[024]
				sxfrctl1!														\					[830]
			then																\					[0b2]
		then																	\					[0b2]
	then																		\					[0b2]
	reset-channel																\					[8b0]
	7899?																		\					[804]
	if																			\ (0x5)				[014]
		nvram-get-stpwlevel														\					[894]
	then																		\					[0b2]
	nvram-get-termination														\					[893]
	select-termination															\					[8ac]
	reset-bus																	\					[8af]
	32																			\					[010]
	seq-ctl!																	\					[84d]
	0																			\					[0a5]
	seq-addr!																	\					[855]
	80																			\					[010]
	brkaddr!																	\					[856]
	80																			\					[010]
	sxfrctl0!																	\					[82e]
	unpause																		\					[898]
	create-sg-list																\					[870]
	create-dummy																\					[829]
	-1																			\					[0a4]
	;																			\					[0c2]



external

: reopen-hardware																\ (8be)				[0ca 0b7]
	-1																			\					[0a4]
	;																			\					[0c2]


: reclose-hardware																\ (8bf)				[0ca 0b7]
	;																			\					[0c2]


: bus-reset																		\ (8c0)				[0ca 0b7]
	reset-bus																	\					[8af]
	;																			\					[0c2]

8000 constant my-max															\ (8c1 8000)		[010 0ca 0ba]

: max-transfer																	\ (8c2)				[0ca 0b7]
	apple-max-transfer?															\					[806]
	if																			\ (0x8)				[014]
		my-max																	\					[8c1]
	else																		\ (0x21)			[013 0b2]
		" max-transfer"															\					[012]
		['] $call-parent														\					[011 209]
		catch																	\					[217]
		if																		\ (0x6)				[014]
			2drop																\					[052]
			my-max																\					[8c1]
		then																	\					[0b2]
		my-max																	\					[8c1]
		min																		\					[02e]
	then																		\					[0b2]
	;																			\					[0c2]


: set-timeout																	\ (8c3)				[0ca 0b7]
	drop																		\					[046]
	;																			\					[0c2]


headers

-1 value inq-buf																\ (8c4 -1)			[0a4 0b6 0b8]
-1 value sense-buf																\ (8c5 -1)			[0a4 0b6 0b8]
0 value #retries																\ (8c6 0)			[0a5 0b6 0b8]

: classify-sense																\ (8c7)				[0b6 0b7]
	debug?																		\					[80d]
	if																			\ (0x35)			[014]
		base																	\					[0a0]
		@																		\					[06d]
		>r																		\					[030]
		hex																		\					[010 0a0 072]
		." Sense:  "															\					[012 090]
		sense-buf																\					[8c5]
		11																		\					[010]
		bounds																	\					[0ac]
		do																		\ (0x9)				[017]
			i																	\					[019]
			c@																	\					[071]
			3																	\					[0a8]
			u.r																	\					[09c]
		loop																	\ (0xfffb)			[015]
		."  ..."																\					[012 090]
		cr																		\					[092]
		r>																		\					[031]
		base																	\					[0a0]
		!																		\					[072]
	then																		\					[0b2]
	sense-buf																	\					[8c5]
	dup																			\					[047]
	c@																			\					[071]
	7f																			\					[010]
	and																			\					[023]
	70																			\					[010]
	<>																			\					[03d]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	dup																			\					[047]
	2+																			\					[0a7 01e]
	c@																			\					[071]
	0e0																			\					[010]
	and																			\					[023]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	2+																			\					[0a7 01e]
	c@																			\					[071]
	0f																			\					[010]
	and																			\					[023]
	dup																			\					[047]
	1																			\					[0a6]
	<=																			\					[043]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	dup																			\					[047]
	2																			\					[0a7]
	=																			\					[03c]
	if																			\ (0x29)			[014]
		drop																	\					[046]
		sense-buf																\					[8c5]
		0c																		\					[010]
		+																		\					[01e]
		c@																		\					[071]
		3a																		\					[010]
		=																		\					[03c]
		sense-buf																\					[8c5]
		0d																		\					[010]
		+																		\					[01e]
		c@																		\					[071]
		0=																		\					[034]
		and																		\					[023]
		if																		\ (0x7)				[014]
			-1																	\					[0a4]
		else																	\ (0x5)				[013 0b2]
			1																	\					[0a6]
		then																	\					[0b2]
		exit																	\					[033]
	then																		\					[0b2]
	dup																			\					[047]
	3																			\					[0a8]
	=																			\					[03c]
	over																		\					[048]
	6																			\					[010]
	=																			\					[03c]
	or																			\					[024]
	swap																		\					[049]
	0b																			\					[010]
	=																			\					[03c]
	or																			\					[024]
	if																			\ (0x7)				[014]
		1																		\					[0a6]
	else																		\ (0x5)				[013 0b2]
		-1																		\					[0a4]
	then																		\					[0b2]
	;																			\					[0c2]

0 value open-count																\ (8c8 0)			[0a5 0b6 0b8]


external

: decode-unit																	\ (8c9)				[0ca 0b7]
	parse-2int																	\					[11b]
	;																			\					[0c2]


: open																			\ (8ca)				[0ca 0b7]
	open-count																	\					[8c8]
	if																			\ (0x15)			[014]
		reopen-hardware															\					[8be]
		dup																		\					[047]
		if																		\ (0xa)				[014]
			open-count															\					[8c8]
			1+																	\					[0a6 01e]
			to open-count														\					[0c3 8c8]
		then																	\					[0b2]
		exit																	\					[033]
	else																		\ (0x23)			[013 0b2]
		open-hardware															\					[8bd]
		dup																		\					[047]
		if																		\ (0x1b)			[014]
			1																	\					[0a6]
			to open-count														\					[0c3 8c8]
			100																	\					[010]
			dma-alloc															\					[81b]
			to sense-buf														\					[0c3 8c5]
			100																	\					[010]
			dma-alloc															\					[81b]
			to inq-buf															\					[0c3 8c4]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]


: close																			\ (8cb)				[0ca 0b7]
	open-count																	\					[8c8]
	1-																			\					[0a6 01f]
	to open-count																\					[0c3 8c8]
	open-count																	\					[8c8]
	if																			\ (0x8)				[014]
		reclose-hardware														\					[8bf]
	else																		\ (0x18)			[013 0b2]
		close-hardware															\					[8ba]
		inq-buf																	\					[8c4]
		100																		\					[010]
		dma-free																\					[81c]
		sense-buf																\					[8c5]
		100																		\					[010]
		dma-free																\					[81c]
	then																		\					[0b2]
	;																			\					[0c2]


headers

create sense-cmd																\ (8cc)				[0b6 0bb]
3																				\					[0a8]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0ff																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: get-sense																		\ (8cd)				[0b6 0b7]
	sense-buf																	\					[8c5]
	0ff																			\					[010]
	-1																			\					[0a4]
	sense-cmd																	\					[8cc]
	6																			\					[010]
	execute-command																\					[8b9]
	0=																			\					[034]
	if																			\ (0x4)				[014]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]


: delay-retry																	\ (8ce)				[0b6 0b7]
	1000																		\					[010]
	0																			\					[0a5]
	do																			\ (0x5)				[017]
	loop																		\ (0xffff)			[015]
	;																			\					[0c2]

0 value statbyte																\ (8cf 0)			[0a5 0b6 0b8]

: retry?																		\ (8d0)				[0b6 0b7]
	case																		\					[0c4]
		0																		\					[0a5]
		of																		\ (0x8)				[01c]
			to statbyte															\					[0c3 8cf]
		endof																	\ (0x13)			[0c6]
		99																		\					[010]
		of																		\ (0x7)				[01c]
			-1																	\					[0a4]
			exit																\					[033]
		endof																	\ (0x6)				[0c6]
		-1																		\					[0a4]
		0																		\					[0a5]
		exit																	\					[033]
	endcase																		\					[0c5]
	statbyte																	\					[8cf]
	0=																			\					[034]
	if																			\ (0x6)				[014]
		0																		\					[0a5]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	statbyte																	\					[8cf]
	2																			\					[0a7]
	and																			\					[023]
	if																			\ (0x2f)			[014]
		get-sense																\					[8cd]
		classify-sense															\					[8c7]
		case																	\					[0c4]
			0																	\					[0a5]
			of																	\ (0x8)				[01c]
				0																\					[0a5]
				0																\					[0a5]
				exit															\					[033]
			endof																\ (0x11)			[0c6]
			-1																	\					[0a4]
			of																	\ (0xc)				[01c]
				sense-buf														\					[8c5]
				0																\					[0a5]
				statbyte														\					[8cf]
				0																\					[0a5]
				exit															\					[033]
			endof																\ (0x3)				[0c6]
		endcase																	\					[0c5]
		#retries																\					[8c6]
		0=																		\					[034]
		if																		\ (0xa)				[014]
			sense-buf															\					[8c5]
			0																	\					[0a5]
			statbyte															\					[8cf]
			0																	\					[0a5]
			exit																\					[033]
		then																	\					[0b2]
	then																		\					[0b2]
	statbyte																	\					[8cf]
	0f5																			\					[010]
	and																			\					[023]
	if																			\ (0x8)				[014]
		-1																		\					[0a4]
		statbyte																\					[8cf]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	#retries																	\					[8c6]
	0=																			\					[034]
	if																			\ (0x8)				[014]
		-1																		\					[0a4]
		statbyte																\					[8cf]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	-1																			\					[0a4]
	;																			\					[0c2]

0 instance value dbuf															\ (8d1 0)			[0a5 0c0 0b6 0b8]
0 instance value dlen															\ (8d2 0)			[0a5 0c0 0b6 0b8]
0 instance value direction-in													\ (8d3 0)			[0a5 0c0 0b6 0b8]
-1 instance value cbuf															\ (8d4 -1)			[0a4 0c0 0b6 0b8]
0 instance value clen															\ (8d5 0)			[0a5 0c0 0b6 0b8]


external

: retry-command																	\ (8d6)				[0ca 0b7]
	to #retries																	\					[0c3 8c6]
	to clen																		\					[0c3 8d5]
	to cbuf																		\					[0c3 8d4]
	to direction-in																\					[0c3 8d3]
	to dlen																		\					[0c3 8d2]
	to dbuf																		\					[0c3 8d1]
	begin																		\					[0b1]
		dbuf																	\					[8d1]
		dlen																	\					[8d2]
		direction-in															\					[8d3]
		cbuf																	\					[8d4]
		clen																	\					[8d5]
		execute-command															\					[8b9]
		retry?																	\					[8d0]
		while																	\ (0xf)				[014]
			#retries															\					[8c6]
			1-																	\					[0a6 01f]
			to #retries															\					[0c3 8c6]
			delay-retry															\					[8ce]
	repeat																		\ (0xffe5)			[013 0b2]
	;																			\					[0c2]



headers

: error?																		\ (8d7)				[0b6 0b7]
	dup																			\					[047]
	if																			\ (0xa)				[014]
		swap																	\					[049]
		0=																		\					[034]
		if																		\ (0x4)				[014]
			nip																	\					[04d]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]



external

: no-data-command																\ (8d8)				[0ca 0b7]
	>r																			\					[030]
	0																			\					[0a5]
	0																			\					[0a5]
	-1																			\					[0a4]
	r>																			\					[031]
	6																			\					[010]
	-1																			\					[0a4]
	retry-command																\					[8d6]
	error?																		\					[8d7]
	;																			\					[0c2]


: short-data-command															\ (8d9)				[0ca 0b7]
	>r																			\					[030]
	>r																			\					[030]
	inq-buf																		\					[8c4]
	swap																		\					[049]
	-1																			\					[0a4]
	r>																			\					[031]
	r>																			\					[031]
	-1																			\					[0a4]
	retry-command																\					[8d6]
	error?																		\					[8d7]
	dup																			\					[047]
	0=																			\					[034]
	if																			\ (0x6)				[014]
		inq-buf																	\					[8c4]
		swap																	\					[049]
	then																		\					[0b2]
	;																			\					[0c2]



headers

: 3c!																			\ (8da)				[0b6 0b7]
	>r																			\					[030]
	lbsplit																		\					[07e]
	drop																		\					[046]
	r@																			\					[032]
	c!																			\					[075]
	r@																			\					[032]
	1+																			\					[0a6 01e]
	c!																			\					[075]
	r>																			\					[031]
	2+																			\					[0a7 01e]
	c!																			\					[075]
	;																			\					[0c2]

create inquiry-cmd																\ (8db)				[0b6 0bb]
12																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0ff																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: inquiry																		\ (8dc)				[0b6 0b7]
	inq-buf																		\					[8c4]
	0ff																			\					[010]
	-1																			\					[0a4]
	inquiry-cmd																	\					[8db]
	6																			\					[010]
	8																			\					[010]
	retry-command																\					[8d6]
	error?																		\					[8d7]
	;																			\					[0c2]


: probe-target																	\ (8dd)				[0b6 0b7]
	0																			\					[0a5]
	swap																		\					[049]
	set-address																	\					[87a]
	inquiry																		\					[8dc]
	0=																			\					[034]
	;																			\					[0c2]


: inq@																			\ (8de)				[0b6 0b7]
	inq-buf																		\					[8c4]
	+																			\					[01e]
	c@																			\					[071]
	;																			\					[0c2]


: .scsi1-inquiry																\ (8df)				[0b6 0b7]
	inq-buf																		\					[8c4]
	5																			\					[010]
	ca+																			\					[05e]
	4																			\					[010]
	inq@																		\					[8de]
	0fa																			\					[010]
	min																			\					[02e]
	type																		\					[090]
	;																			\					[0c2]


: .scsi2-inquiry																\ (8e0)				[0b6 0b7]
	inq-buf																		\					[8c4]
	8																			\					[010]
	ca+																			\					[05e]
	1c																			\					[010]
	type																		\					[090]
	;																			\					[0c2]


: show-lun																		\ (8e1)				[0b6 0b7]
	over																		\					[048]
	swap																		\					[049]
	set-address																	\					[87a]
	inquiry																		\					[8dc]
	if																			\ (0x5)				[014]
		drop																	\					[046]
		exit																	\					[033]
	then																		\					[0b2]
	0																			\					[0a5]
	inq@																		\					[8de]
	60																			\					[010]
	and																			\					[023]
	if																			\ (0x5)				[014]
		drop																	\					[046]
		exit																	\					[033]
	then																		\					[0b2]
	."   Unit "																	\					[012 090]
	.																			\					[09d]
	."   "																		\					[012 090]
	1																			\					[0a6]
	inq@																		\					[8de]
	80																			\					[010]
	and																			\					[023]
	if																			\ (0x10)			[014]
		." Removable "															\					[012 090]
	then																		\					[0b2]
	0																			\					[0a5]
	inq@																		\					[8de]
	case																		\					[0c4]
		0																		\					[0a5]
		of																		\ (0xd)				[01c]
			." Disk "															\					[012 090]
		endof																	\ (0x86)			[0c6]
		1																		\					[0a6]
		of																		\ (0xd)				[01c]
			." Tape "															\					[012 090]
		endof																	\ (0x77)			[0c6]
		2																		\					[0a7]
		of																		\ (0x10)			[01c]
			." Printer "														\					[012 090]
		endof																	\ (0x65)			[0c6]
		3																		\					[0a8]
		of																		\ (0x12)			[01c]
			." Processor "														\					[012 090]
		endof																	\ (0x51)			[0c6]
		4																		\					[010]
		of																		\ (0xd)				[01c]
			." WORM "															\					[012 090]
		endof																	\ (0x3e)			[0c6]
		5																		\					[010]
		of																		\ (0x18)			[01c]
			." Read Only device"												\					[012 090]
		endof																	\ (0x20)			[0c6]
		." Device type "														\					[012 090]
		dup																		\					[047]
		.h																		\					[0a0 06d 049 010 0a0 072 09d 0a0 072]
	endcase																		\					[0c5]
	4																			\					[010]
	spaces																		\					[0a5 02f 0a5 018 0a9 08f 015]
	3																			\					[0a8]
	inq@																		\					[8de]
	0f																			\					[010]
	and																			\					[023]
	2																			\					[0a7]
	=																			\					[03c]
	if																			\ (0x8)				[014]
		.scsi2-inquiry															\					[8e0]
	else																		\ (0x6)				[013 0b2]
		.scsi1-inquiry															\					[8df]
	then																		\					[0b2]
	cr																			\					[092]
	;																			\					[0c2]



external

: show-children																	\ (8e2)				[0ca 0b7]
	open																		\					[8ca]
	0=																			\					[034]
	if																			\ (0x24)			[014]
		." Can't open SCSI host adapter"										\					[012 090]
		cr																		\					[092]
		exit																	\					[033]
	then																		\					[0b2]
	" wide"																		\					[012]
	get-my-property																\					[21a]
	if																			\ (0xb)				[014]
		8																		\					[010]
	else																		\ (0xa)				[013 0b2]
		2drop																	\					[052]
		10																		\					[010]
	then																		\					[0b2]
	0																			\					[0a5]
	do																			\ (0x29)			[017]
		i																		\					[019]
		probe-target															\					[8dd]
		if																		\ (0x20)			[014]
			." Target "															\					[012 090]
			i																	\					[019]
			.																	\					[09d]
			cr																	\					[092]
			8																	\					[010]
			0																	\					[0a5]
			do																	\ (0x9)				[017]
				i																\					[019]
				j																\					[01a]
				show-lun														\					[8e1]
			loop																\ (0xfffb)			[015]
		then																	\					[0b2]
	loop																		\ (0xffdb)			[015]
	close																		\					[8cb]
	;																			\					[0c2]


: get-scsi-type																	\ (8e3)				[0ca 0b7]
	open																		\					[8ca]
	0=																			\					[034]
	if																			\ (0x6)				[014]
		2drop																	\					[052]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	swap																		\					[049]
	set-address																	\					[87a]
	inquiry																		\					[8dc]
	if																			\ (0x7)				[014]
		0																		\					[0a5]
	else																		\ (0x19)			[013 0b2]
		0																		\					[0a5]
		inq@																	\					[8de]
		dup																		\					[047]
		7f																		\					[010]
		=																		\					[03c]
		if																		\ (0x8)				[014]
			drop																\					[046]
			0																	\					[0a5]
		else																	\ (0x5)				[013 0b2]
			-1																	\					[0a4]
		then																	\					[0b2]
	then																		\					[0b2]
	close																		\					[8cb]
	;																			\					[0c2]


headers

create test-unit-rdy-cmd														\ (8e4)				[0b6 0bb]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
create send-diagnostic-cmd														\ (8e5)				[0b6 0bb]
1d																				\					[010]
c,																				\					[0d0]
4																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: send-diagnostic																\ (8e6)				[0b6 0b7]
	send-diagnostic-cmd															\					[8e5]
	no-data-command																\					[8d8]
	;																			\					[0c2]



external

: diagnose																		\ (8e7)				[0ca 0b7]
	0																			\					[0a5]
	0																			\					[0a5]
	-1																			\					[0a4]
	test-unit-rdy-cmd															\					[8e4]
	6																			\					[010]
	-1																			\					[0a4]
	retry-command																\					[8d6]
	if																			\ (0x82)			[014]
		." Test unit ready failed - "											\					[012 090]
		if																		\ (0x2a)			[014]
			." hardware error (no such device?)"								\					[012 090]
			cr																	\					[092]
		else																	\ (0x37)			[013 0b2]
			." extended status = "												\					[012 090]
			cr																	\					[092]
			base																\					[0a0]
			@																	\					[06d]
			>r																	\					[030]
			hex																	\					[010 0a0 072]
			8																	\					[010]
			bounds																\					[0ac]
			?do																	\ (0x8)				[018]
				i																\					[019]
				3																\					[0a8]
				u.r																\					[09c]
			loop																\ (0xfffc)			[015]
			cr																	\					[092]
			r>																	\					[031]
			base																\					[0a0]
			!																	\					[072]
		then																	\					[0b2]
		-1																		\					[0a4]
	else																		\ (0x6)				[013 0b2]
		send-diagnostic															\					[8e6]
	then																		\					[0b2]
	;																			\					[0c2]


headers

-1 value old-control															\ (8e8 -1)			[010 0b6 0b8]
-1 value old-rombase															\ (8e9 -1)			[010 0b6 0b8]
-1 value my-regs																\ (8ea -1)			[010 0b6 0b8]
-1 value my-rom																	\ (8eb -1)			[010 0b6 0b8]

: rom-map																		\ (8ec)				[0b6 0b7]
	my-address																	\					[102]
	2000014																		\					[010]
	my-space																	\					[103]
	or																			\					[024]
	100																			\					[010]
	" map-in"																	\					[012]
	$call-parent																\					[209]
	to my-regs																	\					[0c3 8ea]
	my-address																	\					[102]
	2000030																		\					[010]
	my-space																	\					[103]
	or																			\					[024]
	10000																		\					[010]
	" map-in"																	\					[012]
	$call-parent																\					[209]
	to my-rom																	\					[0c3 8eb]
	my-space																	\					[103]
	4																			\					[010]
	+																			\					[01e]
	dup																			\					[047]
	" config-w@"																\					[012]
	$call-parent																\					[209]
	dup																			\					[047]
	to old-control																\					[0c3 8e8]
	3																			\					[0a8]
	or																			\					[024]
	swap																		\					[049]
	" config-w!"																\					[012]
	$call-parent																\					[209]
	my-space																	\					[103]
	30																			\					[010]
	+																			\					[01e]
	dup																			\					[047]
	" config-l@"																\					[012]
	$call-parent																\					[209]
	dup																			\					[047]
	to old-rombase																\					[0c3 8e9]
	1																			\					[0a6]
	or																			\					[024]
	swap																		\					[049]
	" config-l!"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: rom-unmap																		\ (8ed)				[0b6 0b7]
	my-regs																		\					[8ea]
	100																			\					[010]
	" map-out"																	\					[012]
	$call-parent																\					[209]
	my-rom																		\					[8eb]
	10000																		\					[010]
	" map-out"																	\					[012]
	$call-parent																\					[209]
	old-control																	\					[8e8]
	my-space																	\					[103]
	4																			\					[010]
	+																			\					[01e]
	" config-w!"																\					[012]
	$call-parent																\					[209]
	old-rombase																	\					[8e9]
	my-space																	\					[103]
	30																			\					[010]
	+																			\					[01e]
	" config-l!"																\					[012]
	$call-parent																\					[209]
	-1																			\					[010]
	to my-regs																	\					[0c3 8ea]
	-1																			\					[010]
	to my-rom																	\					[0c3 8eb]
	;																			\					[0c2]


: set-second-page																\ (8ee)				[0b6 0b7]
	my-regs																		\					[8ea]
	1e																			\					[010]
	ca+																			\					[05e]
	dup																			\					[047]
	20																			\					[010]
	swap																		\					[049]
	rb!																			\					[231]
	begin																		\					[0b1]
		my-regs																	\					[8ea]
		1e																		\					[010]
		ca+																		\					[05e]
		rb@																		\					[230]
		80																		\					[010]
		and																		\					[023]
		0=																		\					[034]
	until																		\ (0xffee)			[014]
	dup																			\					[047]
	rot																			\					[04a]
	if																			\ (0xb)				[014]
		22																		\					[010]
	else																		\ (0x9)				[013 0b2]
		20																		\					[010]
	then																		\					[0b2]
	2dup																		\					[053]
	2dup																		\					[053]
	swap																		\					[049]
	rb!																			\					[231]
	8																			\					[010]
	or																			\					[024]
	swap																		\					[049]
	rb!																			\					[231]
	swap																		\					[049]
	rb!																			\					[231]
	0																			\					[0a5]
	swap																		\					[049]
	rb!																			\					[231]
	;																			\					[0c2]

0 value string-length															\ (8ef 0)			[0a5 0b6 0b8]
create string-buffer															\ (8f0)				[0b6 0bb]
256																				\					[010]
allot																			\					[0a5 02f 0a5 018 0a5 0d0 015]
0 value string-prop-adr															\ (8f1 0)			[0a5 0b6 0b8]
0 value string-prop-len															\ (8f2 0)			[0a5 0b6 0b8]
0 value saved-prop-adr															\ (8f3 0)			[0a5 0b6 0b8]
0 value saved-prop-len															\ (8f4 0)			[0a5 0b6 0b8]

: read-byte																		\ (8f5)				[0b6 0b7]
	dup																			\					[047]
	3																			\					[0a8]
	pick																		\					[04e]
	swap																		\					[049]
	ca+																			\					[05e]
	c@																			\					[071]
	swap																		\					[049]
	1+																			\					[0a6 01e]
	swap																		\					[049]
	;																			\					[0c2]


: read-addr																		\ (8f6)				[0b6 0b7]
	dup																			\					[047]
	3																			\					[0a8]
	pick																		\					[04e]
	ca+																			\					[05e]
	;																			\					[0c2]


: find-header																	\ (8f7)				[0b6 0b7]
	400																			\					[010]
	<																			\					[03a]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	9fc4																		\					[010]
	0																			\					[0a5]
	do																			\ (0x32)			[017]
		dup																		\					[047]
		i																		\					[019]
		chars																	\					[066]
		+																		\					[01e]
		dup																		\					[047]
		c@																		\					[071]
		4a																		\					[010]
		=																		\					[03c]
		if																		\ (0x1e)			[014]
			" Joy!peffpwpc"														\					[012]
			comp																\					[07a]
			0=																	\					[034]
			if																	\ (0x7)				[014]
				drop															\					[046]
				i																\					[019]
				unloop															\					[089]
				exit															\					[033]
			then																\					[0b2]
		else																	\ (0x5)				[013 0b2]
			drop																\					[046]
		then																	\					[0b2]
	loop																		\ (0xffd2)			[015]
	drop																		\					[046]
	-1																			\					[0a4]
	;																			\					[0c2]

7 constant header-offset														\ (8f8 7)			[010 0b6 0ba]

: 3drop																			\ (8f9)				[0b6 0b7]
	3drop																		\					[046 052]
	;																			\					[0c2]


: find-property																	\ (8fa)				[0b6 0b7]
	2dup																		\					[053]
	find-header																	\					[8f7]
	dup																			\					[047]
	header-offset																\					[8f8]
	<																			\					[03a]
	if																			\ (0x8)				[014]
		3drop																	\					[8f9]
		0																		\					[0a5]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	header-offset																\					[8f8]
	-																			\					[01f]
	begin																		\					[0b1]
		read-byte																\					[8f5]
		case																	\					[0c4]
			12																	\					[010]
			of																	\ (0x14)			[01c]
				read-byte														\					[8f5]
				to string-length												\					[0c3 8ef]
				read-addr														\					[8f6]
				string-buffer													\					[8f0]
				string-length													\					[8ef]
				move															\					[078]
				string-length													\					[8ef]
				+																\					[01e]
			endof																\ (0x85)			[0c6]
			7b																	\					[010]
			of																	\ (0xc)				[01c]
				3drop															\					[8f9]
				saved-prop-adr													\					[8f3]
				saved-prop-len													\					[8f4]
				exit															\					[033]
			endof																\ (0x73)			[0c6]
			1																	\					[010]
			of																	\ (0x64)			[01c]
				read-byte														\					[8f5]
				case															\					[0c4]
					15															\					[010]
					of															\ (0x22)			[01c]
						string-buffer											\					[8f0]
						string-length											\					[8ef]
						encode-bytes											\					[115]
						saved-prop-len											\					[8f4]
						0=														\					[034]
						if														\ (0xc)				[014]
							to saved-prop-len									\					[0c3 8f4]
							to saved-prop-adr									\					[0c3 8f3]
						else													\ (0xa)				[013 0b2]
							to string-prop-len									\					[0c3 8f2]
							to string-prop-adr									\					[0c3 8f1]
						then													\					[0b2]
					endof														\ (0x36)			[0c6]
					12															\					[010]
					of															\ (0x15)			[01c]
						saved-prop-adr											\					[8f3]
						saved-prop-len											\					[8f4]
						string-prop-adr											\					[8f1]
						string-prop-len											\					[8f2]
						encode+													\					[112]
						to saved-prop-len										\					[0c3 8f4]
						to saved-prop-adr										\					[0c3 8f3]
					endof														\ (0x1b)			[0c6]
					10															\					[010]
					of															\ (0xc)				[01c]
						3drop													\					[8f9]
						saved-prop-adr											\					[8f3]
						saved-prop-len											\					[8f4]
						exit													\					[033]
					endof														\ (0x9)				[0c6]
					drop														\					[046]
					3drop														\					[8f9]
					0															\					[0a5]
					0															\					[0a5]
					exit														\					[033]
				endcase															\					[0c5]
			endof																\ (0x9)				[0c6]
			drop																\					[046]
			3drop																\					[8f9]
			0																	\					[0a5]
			0																	\					[0a5]
			exit																\					[033]
		endcase																	\					[0c5]
		2dup																	\					[053]
		<																		\					[03a]
	until																		\ (0xff5d)			[014]
	3drop																		\					[8f9]
	0																			\					[0a5]
	0																			\					[0a5]
	;																			\					[0c2]

1 constant s_st																	\ (8fb 1)			[0a6 0b6 0ba]
2 constant s_m1																	\ (8fc 2)			[0a7 0b6 0ba]
3 constant s_f																	\ (8fd 3)			[0a8 0b6 0ba]
4 constant s_mt																	\ (8fe 4)			[010 0b6 0ba]
5 constant s_cm																	\ (8ff 5)			[010 0b6 0ba]
6 constant s_md																	\ (900 6)			[010 0b6 0ba]
7 constant s_e																	\ (901 7)			[010 0b6 0ba]
variable p_state																\ (902)				[0b6 0b9]
variable t																		\ (903)				[0b6 0b9]
variable ip																		\ (904)				[0b6 0b9]
variable op																		\ (905)				[0b6 0b9]
variable mpos																	\ (906)				[0b6 0b9]

: ipc@																			\ (907)				[0b6 0b7]
	ip																			\					[904]
	@																			\					[06d]
	c@																			\					[071]
	;																			\					[0c2]


: ip++																			\ (908)				[0b6 0b7]
	ip																			\					[904]
	@																			\					[06d]
	1+																			\					[0a6 01e]
	ip																			\					[904]
	!																			\					[072]
	;																			\					[0c2]


: ipc@++																		\ (909)				[0b6 0b7]
	ipc@																		\					[907]
	ip++																		\					[908]
	;																			\					[0c2]


: t!																			\ (90a)				[0b6 0b7]
	t																			\					[903]
	!																			\					[072]
	;																			\					[0c2]


: t@																			\ (90b)				[0b6 0b7]
	t																			\					[903]
	@																			\					[06d]
	;																			\					[0c2]


: op@																			\ (90c)				[0b6 0b7]
	op																			\					[905]
	@																			\					[06d]
	;																			\					[0c2]


: mpos@																			\ (90d)				[0b6 0b7]
	mpos																		\					[906]
	@																			\					[06d]
	;																			\					[0c2]


: mpos!																			\ (90e)				[0b6 0b7]
	mpos																		\					[906]
	!																			\					[072]
	;																			\					[0c2]


: st!																			\ (90f)				[0b6 0b7]
	p_state																		\					[902]
	!																			\					[072]
	;																			\					[0c2]

0 value bufst																	\ (910 0)			[0a5 0b6 0b8]
1000 constant buflen															\ (911 1000)		[010 0b6 0ba]
0 value buf-offset																\ (912 0)			[0a5 0b6 0b8]
0 value propadr																	\ (913 0)			[0a5 0b6 0b8]
0 value proplen																	\ (914 0)			[0a5 0b6 0b8]

: write-buffer																	\ (915)				[0b6 0b7]
	>r																			\					[030]
	bufst																		\					[910]
	r@																			\					[032]
	encode-bytes																\					[115]
	proplen																		\					[914]
	0=																			\					[034]
	invert																		\					[026]
	if																			\ (0xa)				[014]
		propadr																	\					[913]
		proplen																	\					[914]
		2swap																	\					[055]
		encode+																	\					[112]
	then																		\					[0b2]
	to proplen																	\					[0c3 914]
	to propadr																	\					[0c3 913]
	op@																			\					[90c]
	r@																			\					[032]
	-																			\					[01f]
	op																			\					[905]
	!																			\					[072]
	buf-offset																	\					[912]
	r>																			\					[031]
	+																			\					[01e]
	to buf-offset																\					[0c3 912]
	;																			\					[0c2]


: op-off																		\ (916)				[0b6 0b7]
	op@																			\					[90c]
	bufst																		\					[910]
	-																			\					[01f]
	dup																			\					[047]
	;																			\					[0c2]


: flush-buffer																	\ (917)				[0b6 0b7]
	op-off																		\					[916]
	0>																			\					[038]
	if																			\ (0x8)				[014]
		write-buffer															\					[915]
	else																		\ (0x5)				[013 0b2]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]


: check-op																		\ (918)				[0b6 0b7]
	op-off																		\					[916]
	buflen																		\					[911]
	=																			\					[03c]
	if																			\ (0x8)				[014]
		write-buffer															\					[915]
	else																		\ (0x5)				[013 0b2]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]


: set-mpos																		\ (919)				[0b6 0b7]
	op@																			\					[90c]
	bufst																		\					[910]
	-																			\					[01f]
	buf-offset																	\					[912]
	+																			\					[01e]
	swap																		\					[049]
	-																			\					[01f]
	mpos!																		\					[90e]
	;																			\					[0c2]


: opc!																			\ (91a)				[0b6 0b7]
	check-op																	\					[918]
	op@																			\					[90c]
	c!																			\					[075]
	op@																			\					[90c]
	1+																			\					[0a6 01e]
	op																			\					[905]
	!																			\					[072]
	;																			\					[0c2]


: op++=mpos																		\ (91b)				[0b6 0b7]
	mpos@																		\					[90d]
	buf-offset																	\					[912]
	<																			\					[03a]
	if																			\ (0x8)				[014]
		propadr																	\					[913]
	else																		\ (0x9)				[013 0b2]
		bufst																	\					[910]
		buf-offset																\					[912]
		-																		\					[01f]
	then																		\					[0b2]
	mpos@																		\					[90d]
	+																			\					[01e]
	c@																			\					[071]
	opc!																		\					[91a]
	;																			\					[0c2]


: mpos-ptr																		\ (91c)				[0b6 0b7]
	bufst																		\					[910]
	mpos@																		\					[90d]
	+																			\					[01e]
	buf-offset																	\					[912]
	-																			\					[01f]
	;																			\					[0c2]



headerless

: colon_definition_function_91d													\ (91d)				[0b5 0b7]
	mpos@																		\					[90d]
	swap																		\					[049]
	-																			\					[01f]
	mpos!																		\					[90e]
	;																			\					[0c2]


: colon_definition_function_91e													\ (91e)				[0b5 0b7]
	mpos@																		\					[90d]
	1+																			\					[0a6 01e]
	mpos!																		\					[90e]
	;																			\					[0c2]


: colon_definition_function_91f													\ (91f)				[0b5 0b7]
	ipc@++																		\					[909]
	opc!																		\					[91a]
	;																			\					[0c2]


: colon_definition_function_920													\ (920)				[0b5 0b7]
	op++=mpos																	\					[91b]
	colon_definition_function_91e												\ (91e)				[91e]
	;																			\					[0c2]


: colon_definition_function_921													\ (921)				[0b5 0b7]
	ipc@																		\					[907]
	11																			\					[010]
	>																			\					[03b]
	if																			\ (0x23)			[014]
		ipc@++																	\					[909]
		11																		\					[010]
		-																		\					[01f]
		t!																		\					[90a]
		begin																	\					[0b1]
			colon_definition_function_91f										\ (91f)				[91f]
			t@																	\					[90b]
			1-																	\					[0a6 01f]
			t!																	\					[90a]
			t@																	\					[90b]
			0=																	\					[034]
		until																	\ (0xfff4)			[014]
		s_f																		\					[8fd]
		st!																		\					[90f]
	else																		\ (0x8)				[013 0b2]
		s_m1																	\					[8fc]
		st!																		\					[90f]
	then																		\					[0b2]
	;																			\					[0c2]


: colon_definition_function_922													\ (922)				[0b5 0b7]
	ipc@++																		\					[909]
	t!																			\					[90a]
	t@																			\					[90b]
	0f																			\					[010]
	>																			\					[03b]
	if																			\ (0xa)				[014]
		s_mt																	\					[8fe]
		st!																		\					[90f]
	else																		\ (0x48)			[013 0b2]
		t@																		\					[90b]
		0=																		\					[034]
		if																		\ (0x27)			[014]
			begin																\					[0b1]
				ipc@															\					[907]
				0=																\					[034]
				while															\ (0x12)			[014]
					t@															\					[90b]
					0ff															\					[010]
					+															\					[01e]
					t!															\					[90a]
					ip++														\					[908]
			repeat																\ (0xffed)			[013 0b2]
			ipc@++																\					[909]
			0f																	\					[010]
			+																	\					[01e]
			t@																	\					[90b]
			+																	\					[01e]
			t!																	\					[90a]
		then																	\					[0b2]
		colon_definition_function_91f											\ (91f)				[91f]
		colon_definition_function_91f											\ (91f)				[91f]
		colon_definition_function_91f											\ (91f)				[91f]
		begin																	\					[0b1]
			colon_definition_function_91f										\ (91f)				[91f]
			t@																	\					[90b]
			1-																	\					[0a6 01f]
			t!																	\					[90a]
			t@																	\					[90b]
			0=																	\					[034]
		until																	\ (0xfff4)			[014]
		s_f																		\					[8fd]
		st!																		\					[90f]
	then																		\					[0b2]
	;																			\					[0c2]


: colon_definition_function_923													\ (923)				[0b5 0b7]
	ipc@++																		\					[909]
	t!																			\					[90a]
	t@																			\					[90b]
	0f																			\					[010]
	>																			\					[03b]
	if																			\ (0xa)				[014]
		s_mt																	\					[8fe]
		st!																		\					[90f]
	else																		\ (0x21)			[013 0b2]
		801																		\					[010]
		set-mpos																\					[919]
		t@																		\					[90b]
		2																		\					[0a7]
		rshift																	\					[028]
		colon_definition_function_91d											\ (91d)				[91d]
		ipc@++																	\					[909]
		2																		\					[0a7]
		lshift																	\					[027]
		colon_definition_function_91d											\ (91d)				[91d]
		colon_definition_function_920											\ (920)				[920]
		colon_definition_function_920											\ (920)				[920]
		op++=mpos																\					[91b]
		s_md																	\					[900]
		st!																		\					[90f]
	then																		\					[0b2]
	;																			\					[0c2]


: colon_definition_function_924													\ (924)				[0b5 0b7]
	1																			\					[0a6]
	set-mpos																	\					[919]
	t@																			\					[90b]
	2																			\					[0a7]
	rshift																		\					[028]
	7																			\					[010]
	and																			\					[023]
	colon_definition_function_91d												\ (91d)				[91d]
	ipc@++																		\					[909]
	3																			\					[0a8]
	lshift																		\					[027]
	colon_definition_function_91d												\ (91d)				[91d]
	t@																			\					[90b]
	5																			\					[010]
	rshift																		\					[028]
	1-																			\					[0a6 01f]
	t!																			\					[90a]
	s_cm																		\					[8ff]
	st!																			\					[90f]
	;																			\					[0c2]


: colon_definition_function_925													\ (925)				[0b5 0b7]
	t@																			\					[90b]
	1f																			\					[010]
	and																			\					[023]
	t!																			\					[90a]
	t@																			\					[90b]
	0=																			\					[034]
	if																			\ (0x27)			[014]
		begin																	\					[0b1]
			ipc@																\					[907]
			0=																	\					[034]
			while																\ (0x12)			[014]
				t@																\					[90b]
				0ff																\					[010]
				+																\					[01e]
				t!																\					[90a]
				ip++															\					[908]
		repeat																	\ (0xffed)			[013 0b2]
		ipc@++																	\					[909]
		1f																		\					[010]
		+																		\					[01e]
		t@																		\					[90b]
		+																		\					[01e]
		t!																		\					[90a]
	then																		\					[0b2]
	1																			\					[0a6]
	set-mpos																	\					[919]
	ipc@++																		\					[909]
	2																			\					[0a7]
	rshift																		\					[028]
	colon_definition_function_91d												\ (91d)				[91d]
	ipc@++																		\					[909]
	6																			\					[010]
	lshift																		\					[027]
	colon_definition_function_91d												\ (91d)				[91d]
	;																			\					[0c2]


: colon_definition_function_926													\ (926)				[0b5 0b7]
	0																			\					[0a5]
	set-mpos																	\					[919]
	t@																			\					[90b]
	8																			\					[010]
	and																			\					[023]
	0b																			\					[010]
	lshift																		\					[027]
	colon_definition_function_91d												\ (91d)				[91d]
	t@																			\					[90b]
	7																			\					[010]
	and																			\					[023]
	t!																			\					[90a]
	t@																			\					[90b]
	0=																			\					[034]
	if																			\ (0x27)			[014]
		begin																	\					[0b1]
			ipc@																\					[907]
			0=																	\					[034]
			while																\ (0x12)			[014]
				t@																\					[90b]
				0ff																\					[010]
				+																\					[01e]
				t!																\					[90a]
				ip++															\					[908]
		repeat																	\ (0xffed)			[013 0b2]
		ipc@++																	\					[909]
		7																		\					[010]
		+																		\					[01e]
		t@																		\					[90b]
		+																		\					[01e]
		t!																		\					[90a]
	then																		\					[0b2]
	ipc@++																		\					[909]
	2																			\					[0a7]
	rshift																		\					[028]
	colon_definition_function_91d												\ (91d)				[91d]
	ipc@++																		\					[909]
	6																			\					[010]
	lshift																		\					[027]
	colon_definition_function_91d												\ (91d)				[91d]
	op@																			\					[90c]
	mpos-ptr																	\					[91c]
	=																			\					[03c]
	if																			\ (0xa)				[014]
		s_e																		\					[901]
		st!																		\					[90f]
	else																		\ (0xb)				[013 0b2]
		4000																	\					[010]
		colon_definition_function_91d											\ (91d)				[91d]
	then																		\					[0b2]
	;																			\					[0c2]


: colon_definition_function_927													\ (927)				[0b5 0b7]
	1																			\					[0a6]
	set-mpos																	\					[919]
	t@																			\					[90b]
	2																			\					[0a7]
	rshift																		\					[028]
	colon_definition_function_91d												\ (91d)				[91d]
	ipc@++																		\					[909]
	2																			\					[0a7]
	lshift																		\					[027]
	colon_definition_function_91d												\ (91d)				[91d]
	colon_definition_function_920												\ (920)				[920]
	op++=mpos																	\					[91b]
	s_md																		\					[900]
	st!																			\					[90f]
	;																			\					[0c2]


: colon_definition_function_928													\ (928)				[0b5 0b7]
	s_cm																		\					[8ff]
	st!																			\					[90f]
	t@																			\					[90b]
	3f																			\					[010]
	>																			\					[03b]
	if																			\ (0x8)				[014]
		colon_definition_function_924											\ (924)				[924]
	else																		\ (0x2a)			[013 0b2]
		t@																		\					[90b]
		1f																		\					[010]
		>																		\					[03b]
		if																		\ (0x8)				[014]
			colon_definition_function_925										\ (925)				[925]
		else																	\ (0x18)			[013 0b2]
			t@																	\					[90b]
			0f																	\					[010]
			>																	\					[03b]
			if																	\ (0x8)				[014]
				colon_definition_function_926									\ (926)				[926]
			else																\ (0x6)				[013 0b2]
				colon_definition_function_927									\ (927)				[927]
			then																\					[0b2]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]


: colon_definition_function_929													\ (929)				[0b5 0b7]
	colon_definition_function_920												\ (920)				[920]
	colon_definition_function_920												\ (920)				[920]
	begin																		\					[0b1]
		colon_definition_function_920											\ (920)				[920]
		t@																		\					[90b]
		1-																		\					[0a6 01f]
		t!																		\					[90a]
		t@																		\					[90b]
		0=																		\					[034]
	until																		\ (0xfff4)			[014]
	s_md																		\					[900]
	st!																			\					[90f]
	;																			\					[0c2]


: colon_definition_function_92a													\ (92a)				[0b5 0b7]
	ip																			\					[904]
	@																			\					[06d]
	2-																			\					[0a7 01f]
	c@																			\					[071]
	3																			\					[0a8]
	and																			\					[023]
	t!																			\					[90a]
	t@																			\					[90b]
	0=																			\					[034]
	if																			\ (0xa)				[014]
		s_m1																	\					[8fc]
		st!																		\					[90f]
	else																		\ (0x1b)			[013 0b2]
		begin																	\					[0b1]
			colon_definition_function_91f										\ (91f)				[91f]
			t@																	\					[90b]
			1-																	\					[0a6 01f]
			t!																	\					[90a]
			t@																	\					[90b]
			0=																	\					[034]
		until																	\ (0xfff4)			[014]
		ipc@++																	\					[909]
		t!																		\					[90a]
		s_mt																	\					[8fe]
		st!																		\					[90f]
	then																		\					[0b2]
	;																			\					[0c2]



headers

: dtd																			\ (92b)				[0b6 0b7]
	begin																		\					[0b1]
		p_state																	\					[902]
		@																		\					[06d]
		case																	\					[0c4]
			s_st																\					[8fb]
			of																	\ (0x7)				[01c]
				colon_definition_function_921									\ (921)				[921]
			endof																\ (0x35)			[0c6]
			s_m1																\					[8fc]
			of																	\ (0x7)				[01c]
				colon_definition_function_922									\ (922)				[922]
			endof																\ (0x2b)			[0c6]
			s_f																	\					[8fd]
			of																	\ (0x7)				[01c]
				colon_definition_function_923									\ (923)				[923]
			endof																\ (0x21)			[0c6]
			s_mt																\					[8fe]
			of																	\ (0x7)				[01c]
				colon_definition_function_928									\ (928)				[928]
			endof																\ (0x17)			[0c6]
			s_cm																\					[8ff]
			of																	\ (0x7)				[01c]
				colon_definition_function_929									\ (929)				[929]
			endof																\ (0xd)				[0c6]
			s_md																\					[900]
			of																	\ (0x7)				[01c]
				colon_definition_function_92a									\ (92a)				[92a]
			endof																\ (0x3)				[0c6]
		endcase																	\					[0c5]
		p_state																	\					[902]
		@																		\					[06d]
		s_e																		\					[901]
		=																		\					[03c]
	until																		\ (0xffb8)			[014]
	;																			\					[0c2]


: init-d																		\ (92c)				[0b6 0b7]
	drop																		\					[046]
	4																			\					[010]
	+																			\					[01e]
	ip																			\					[904]
	!																			\					[072]
	buflen																		\					[911]
	alloc-mem																	\					[08b]
	to bufst																	\					[0c3 910]
	bufst																		\					[910]
	op																			\					[905]
	!																			\					[072]
	s_st																		\					[8fb]
	st!																			\					[90f]
	;																			\					[0c2]


: decompress																	\ (92d)				[0b6 0b7]
	init-d																		\					[92c]
	dtd																			\					[92b]
	flush-buffer																\					[917]
	bufst																		\					[910]
	buflen																		\					[911]
	free-mem																	\					[08c]
	propadr																		\					[913]
	proplen																		\					[914]
	;																			\					[0c2]


: decompress_property															\ (92e)				[0b6 0b7]
	>r																			\					[030]
	>r																			\					[030]
	decompress																	\					[92d]
	over																		\					[048]
	0=																			\					[034]
	invert																		\					[026]
	if																			\ (0xa)				[014]
		r>																		\					[031]
		r>																		\					[031]
		property																\					[110]
	else																		\ (0x8)				[013 0b2]
		r>																		\					[031]
		r>																		\					[031]
		2drop																	\					[052]
		2drop																	\					[052]
	then																		\					[0b2]
	;																			\					[0c2]


: read-our-driver																\ (92f)				[0b6 0b7]
	rom-map																		\					[8ec]
	-1																			\					[0a4]
	set-second-page																\					[8ee]
	my-rom																		\					[8eb]
	10000																		\					[010]
	find-property																\					[8fa]
	0																			\					[0a5]
	set-second-page																\					[8ee]
	dup																			\					[047]
	0=																			\					[034]
	if																			\ (0x20)			[014]
		" MacOS driver not found!"												\					[012]
		warning																	\					[80f]
		2drop																	\					[052]
		exit																	\					[033]
	then																		\					[0b2]
	decompress																	\					[92d]
	" driver,AAPL,MacOS,PowerPC"												\					[012]
	property																	\					[110]
	rom-unmap																	\					[8ed]
	;																			\					[0c2]

read-our-driver																	\					[92f]
new-device																		\					[11f]
" disk"																			\					[012]
device-name																		\					[201]
" block"																		\					[012]
device-type																		\					[11a]
" sd"																			\					[012]
encode-string																	\					[114]
" compatible"																	\					[012]
property																		\					[110]


external

: dma-alloc																		\ (930)				[0ca 0b7]
	" dma-alloc"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: dma-free																		\ (931)				[0ca 0b7]
	" dma-free"																	\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]



headers

: parent-max-transfer															\ (932)				[0b6 0b7]
	" max-transfer"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: parent-set-address															\ (933)				[0b6 0b7]
	" set-address"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: retry-command																	\ (934)				[0b6 0b7]
	" retry-command"															\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: no-data-command																\ (935)				[0b6 0b7]
	" no-data-command"															\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: short-data-command															\ (936)				[0b6 0b7]
	" short-data-command"														\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: +c!																			\ (937)				[0b6 0b7]
	tuck																		\					[04c]
	c!																			\					[075]
	1+																			\					[0a6 01e]
	;																			\					[0c2]


: 3c!																			\ (938)				[0b6 0b7]
	>r																			\					[030]
	lbsplit																		\					[07e]
	drop																		\					[046]
	r>																			\					[031]
	+c!																			\					[937]
	+c!																			\					[937]
	c!																			\					[075]
	;																			\					[0c2]


: -c@																			\ (939)				[0b6 0b7]
	dup																			\					[047]
	c@																			\					[071]
	swap																		\					[049]
	1-																			\					[0a6 01f]
	;																			\					[0c2]


: 3c@																			\ (93a)				[0b6 0b7]
	2+																			\					[0a7 01e]
	-c@																			\					[939]
	-c@																			\					[939]
	c@																			\					[071]
	0																			\					[0a5]
	bljoin																		\					[07f]
	;																			\					[0c2]


: 4c@																			\ (93b)				[0b6 0b7]
	3																			\					[0a8]
	+																			\					[01e]
	-c@																			\					[939]
	-c@																			\					[939]
	-c@																			\					[939]
	c@																			\					[071]
	bljoin																		\					[07f]
	;																			\					[0c2]

0a constant /cmdbuf																\ (93c 0a)			[010 0b6 0ba]
create cmdbuf																	\ (93d)				[0b6 0bb]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: cb!																			\ (93e)				[0b6 0b7]
	cmdbuf																		\					[93d]
	+																			\					[01e]
	c!																			\					[075]
	;																			\					[0c2]

create eject-cmd																\ (93f)				[0b6 0bb]
1b																				\					[010]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
2																				\					[0a7]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]


external

: device-present?																\ (940)				[0ca 0b7]
	parent-set-address															\					[933]
	0=																			\					[034]
	if																			\ (0x5)				[014]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	5																			\					[010]
	" inquiry"																	\					[012]
	$call-parent																\					[209]
	invert																		\					[026]
	;																			\					[0c2]


: eject																			\ (941)				[0ca 0b7]
	my-unit																		\					[20d]
	device-present?																\					[940]
	if																			\ (0x8)				[014]
		eject-cmd																\					[93f]
		no-data-command															\					[935]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]


headers

0 instance value deblocker														\ (942 0)			[0a5 0c0 0b6 0b8]

: init-deblocker																\ (943)				[0b6 0b7]
	" "																			\					[012]
	" deblocker"																\					[012]
	$open-package																\					[20f]
	to deblocker																\					[0c3 942]
	deblocker																	\					[942]
	if																			\ (0x7)				[014]
		-1																		\					[0a4]
	else																		\ (0x25)			[013 0b2]
		." Can't open deblocker package"										\					[012 090]
		cr																		\					[092]
		0																		\					[0a5]
	then																		\					[0b2]
	;																			\					[0c2]


: set-timeout																	\ (944)				[0b6 0b7]
	" set-timeout"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]

0 instance value saved-offset-lo												\ (945 0)			[0a5 0c0 0b6 0b8]
0 instance value saved-offset-hi												\ (946 0)			[0a5 0c0 0b6 0b8]

external

0 instance value label-package													\ (947 0)			[0a5 0c0 0ca 0b8]
-1 value report-failure															\ (948 -1)			[0a4 0ca 0b8]


headers

: init-label-package															\ (949)				[0b6 0b7]
	0																			\					[0a5]
	to saved-offset-hi															\					[0c3 946]
	0																			\					[0a5]
	to saved-offset-lo															\					[0c3 945]
	my-args																		\					[202]
	" disk-label"																\					[012]
	$open-package																\					[20f]
	to label-package															\					[0c3 947]
	label-package																\					[947]
	dup																			\					[047]
	if																			\ (0x1a)			[014]
		0																		\					[0a5]
		0																		\					[0a5]
		" offset"																\					[012]
		label-package															\					[947]
		$call-method															\					[20e]
		to saved-offset-hi														\					[0c3 946]
		to saved-offset-lo														\					[0c3 945]
	else																		\ (0x2b)			[013 0b2]
		report-failure															\					[948]
		if																		\ (0x24)			[014]
			." Can't open disk label package"									\					[012 090]
			cr																	\					[092]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]

create sstart-cmd																\ (94a)				[0b6 0bb]
1b																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: timed-spin																	\ (94b)				[0b6 0b7]
	2d																			\					[010]
	3e8																			\					[010]
	*																			\					[020]
	set-timeout																	\					[944]
	0																			\					[0a5]
	0																			\					[0a5]
	-1																			\					[0a4]
	sstart-cmd																	\					[94a]
	6																			\					[010]
	-1																			\					[0a4]
	retry-command																\					[934]
	if																			\ (0x18)			[014]
		if																		\ (0x7)				[014]
			-1																	\					[0a4]
		else																	\ (0xd)				[013 0b2]
			2+																	\					[0a7 01e]
			c@																	\					[071]
			5																	\					[010]
			<>																	\					[03d]
		then																	\					[0b2]
	else																		\ (0x5)				[013 0b2]
		0																		\					[0a5]
	then																		\					[0b2]
	0																			\					[0a5]
	set-timeout																	\					[944]
	;																			\					[0c2]

0 instance value /block															\ (94c 0)			[0a5 0c0 0b6 0b8]
create mode-sense-bd															\ (94d)				[0b6 0bb]
1a																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0c																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
create read-capacity-cmd														\ (94e)				[0b6 0bb]
25																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: read-block-extent																\ (94f)				[0b6 0b7]
	8																			\					[010]
	read-capacity-cmd															\					[94e]
	0a																			\					[010]
	short-data-command															\					[936]
	0=																			\					[034]
	if																			\ (0x13)			[014]
		dup																		\					[047]
		4																		\					[010]
		+																		\					[01e]
		4c@																		\					[93b]
		swap																	\					[049]
		4c@																		\					[93b]
		1+																		\					[0a6 01e]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	0c																			\					[010]
	mode-sense-bd																\					[94d]
	6																			\					[010]
	short-data-command															\					[936]
	0=																			\					[034]
	if																			\ (0x17)			[014]
		dup																		\					[047]
		9																		\					[010]
		+																		\					[01e]
		3c@																		\					[93a]
		swap																	\					[049]
		4																		\					[010]
		+																		\					[01e]
		4c@																		\					[93b]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	-1																			\					[0a4]
	;																			\					[0c2]


: read-block-size																\ (950)				[0b6 0b7]
	read-block-extent															\					[94f]
	if																			\ (0xb)				[014]
		200																		\					[010]
	else																		\ (0x5)				[013 0b2]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]



external

: block-size																	\ (951)				[0ca 0b7]
	/block																		\					[94c]
	if																			\ (0x6)				[014]
		/block																	\					[94c]
		exit																	\					[033]
	then																		\					[0b2]
	read-block-size																\					[950]
	dup																			\					[047]
	to /block																	\					[0c3 94c]
	;																			\					[0c2]



headers

: 2c!																			\ (952)				[0b6 0b7]
	>r																			\					[030]
	lbsplit																		\					[07e]
	2drop																		\					[052]
	r>																			\					[031]
	+c!																			\					[937]
	c!																			\					[075]
	;																			\					[0c2]


: 4c!																			\ (953)				[0b6 0b7]
	>r																			\					[030]
	lbsplit																		\					[07e]
	r>																			\					[031]
	+c!																			\					[937]
	+c!																			\					[937]
	+c!																			\					[937]
	c!																			\					[075]
	;																			\					[0c2]


: r/w-blocks																	\ (954)				[0b6 0b7]
	cmdbuf																		\					[93d]
	/cmdbuf																		\					[93c]
	erase																		\					[0a5 079]
	2over																		\					[054]
	100																			\					[010]
	u>																			\					[03e]
	swap																		\					[049]
	200000																		\					[010]
	u>=																			\					[041]
	or																			\					[024]
	if																			\ (0x27)			[014]
		20																		\					[010]
		or																		\					[024]
		0																		\					[0a5]
		cb!																		\					[93e]
		-rot																	\					[04b]
		swap																	\					[049]
		cmdbuf																	\					[93d]
		2+																		\					[0a7 01e]
		4c!																		\					[953]
		dup																		\					[047]
		cmdbuf																	\					[93d]
		7																		\					[010]
		+																		\					[01e]
		2c!																		\					[952]
		0a																		\					[010]
	else																		\ (0x1c)			[013 0b2]
		0																		\					[0a5]
		cb!																		\					[93e]
		-rot																	\					[04b]
		swap																	\					[049]
		cmdbuf																	\					[93d]
		1+																		\					[0a6 01e]
		3c!																		\					[938]
		dup																		\					[047]
		4																		\					[010]
		cb!																		\					[93e]
		6																		\					[010]
	then																		\					[0b2]
	swap																		\					[049]
	dup																			\					[047]
	>r																			\					[030]
	/block																		\					[94c]
	*																			\					[020]
	-rot																		\					[04b]
	cmdbuf																		\					[93d]
	swap																		\					[049]
	-1																			\					[0a4]
	retry-command																\					[934]
	if																			\ (0xf)				[014]
		0=																		\					[034]
		if																		\ (0x4)				[014]
			drop																\					[046]
		then																	\					[0b2]
		r>																		\					[031]
		drop																	\					[046]
		0																		\					[0a5]
	else																		\ (0x5)				[013 0b2]
		r>																		\					[031]
	then																		\					[0b2]
	;																			\					[0c2]



external

: max-transfer																	\ (955)				[0ca 0b7]
	parent-max-transfer															\					[932]
	;																			\					[0c2]


: read-blocks																	\ (956)				[0ca 0b7]
	-1																			\					[0a4]
	8																			\					[010]
	r/w-blocks																	\					[954]
	;																			\					[0c2]


: write-blocks																	\ (957)				[0ca 0b7]
	0																			\					[0a5]
	0a																			\					[010]
	r/w-blocks																	\					[954]
	;																			\					[0c2]


: open																			\ (958)				[0ca 0b7]
	my-unit																		\					[20d]
	" set-address"																\					[012]
	$call-parent																\					[209]
	timed-spin																	\					[94b]
	if																			\ (0x5)				[014]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	block-size																	\					[951]
	to /block																	\					[0c3 94c]
	init-deblocker																\					[943]
	0=																			\					[034]
	if																			\ (0x5)				[014]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	init-label-package															\					[949]
	0=																			\					[034]
	if																			\ (0x9)				[014]
		deblocker																\					[942]
		close-package															\					[206]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	-1																			\					[0a4]
	;																			\					[0c2]


: close																			\ (959)				[0ca 0b7]
	label-package																\					[947]
	?dup																		\					[050]
	0<>																			\					[035]
	if																			\ (0x9)				[014]
		close-package															\					[206]
		0																		\					[0a5]
		to label-package														\					[0c3 947]
	then																		\					[0b2]
	deblocker																	\					[942]
	?dup																		\					[050]
	0<>																			\					[035]
	if																			\ (0x9)				[014]
		close-package															\					[206]
		0																		\					[0a5]
		to deblocker															\					[0c3 942]
	then																		\					[0b2]
	;																			\					[0c2]


: seek																			\ (95a)				[0ca 0b7]
	saved-offset-lo																\					[945]
	saved-offset-hi																\					[946]
	d+																			\					[0d8]
	" seek"																		\					[012]
	deblocker																	\					[942]
	$call-method																\					[20e]
	;																			\					[0c2]


: read																			\ (95b)				[0ca 0b7]
	" read"																		\					[012]
	deblocker																	\					[942]
	$call-method																\					[20e]
	;																			\					[0c2]


: write																			\ (95c)				[0ca 0b7]
	" write"																	\					[012]
	deblocker																	\					[942]
	$call-method																\					[20e]
	;																			\					[0c2]


: load																			\ (95d)				[0ca 0b7]
	" load"																		\					[012]
	label-package																\					[947]
	$call-method																\					[20e]
	;																			\					[0c2]


: size																			\ (95e)				[0ca 0b7]
	" size"																		\					[012]
	label-package																\					[947]
	$call-method																\					[20e]
	;																			\					[0c2]


: size																			\ (95f)				[0ca 0b7]
	read-block-extent															\					[94f]
	if																			\ (0xe)				[014]
		-1																		\					[0a4]
		dup																		\					[047]
		1f																		\					[010]
		rshift																	\					[028]
	else																		\ (0x5)				[013 0b2]
		um*																		\					[0d4]
	then																		\					[0b2]
	;																			\					[0c2]


: #blocks																		\ (960)				[0ca 0b7]
	read-block-extent															\					[94f]
	if																			\ (0x7)				[014]
		-1																		\					[0a4]
	else																		\ (0x5)				[013 0b2]
		nip																		\					[04d]
	then																		\					[0b2]
	;																			\					[0c2]


: offset-low																	\ (961)				[0ca 0b7]
	saved-offset-lo																\					[945]
	;																			\					[0c2]


: offset-high																	\ (962)				[0ca 0b7]
	saved-offset-hi																\					[946]
	;																			\					[0c2]

finish-device																	\					[127]
new-device																		\					[11f]
" tape"																			\					[012]
device-name																		\					[201]
" byte"																			\					[012]
device-type																		\					[11a]
" st"																			\					[012]
encode-string																	\					[114]
" compatible"																	\					[012]
property																		\					[110]

: dma-alloc																		\ (963)				[0ca 0b7]
	" dma-alloc"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: dma-free																		\ (964)				[0ca 0b7]
	" dma-free"																	\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]



headers

: parent-max-transfer															\ (965)				[0b6 0b7]
	" max-transfer"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: parent-set-address															\ (966)				[0b6 0b7]
	" set-address"																\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: retry-command																	\ (967)				[0b6 0b7]
	" retry-command"															\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: no-data-command																\ (968)				[0b6 0b7]
	" no-data-command"															\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: short-data-command															\ (969)				[0b6 0b7]
	" short-data-command"														\					[012]
	$call-parent																\					[209]
	;																			\					[0c2]


: +c!																			\ (96a)				[0b6 0b7]
	tuck																		\					[04c]
	c!																			\					[075]
	1+																			\					[0a6 01e]
	;																			\					[0c2]


: 3c!																			\ (96b)				[0b6 0b7]
	>r																			\					[030]
	lbsplit																		\					[07e]
	drop																		\					[046]
	r>																			\					[031]
	+c!																			\					[96a]
	+c!																			\					[96a]
	c!																			\					[075]
	;																			\					[0c2]


: -c@																			\ (96c)				[0b6 0b7]
	dup																			\					[047]
	c@																			\					[071]
	swap																		\					[049]
	1-																			\					[0a6 01f]
	;																			\					[0c2]


: 3c@																			\ (96d)				[0b6 0b7]
	2+																			\					[0a7 01e]
	-c@																			\					[96c]
	-c@																			\					[96c]
	c@																			\					[071]
	0																			\					[0a5]
	bljoin																		\					[07f]
	;																			\					[0c2]


: 4c@																			\ (96e)				[0b6 0b7]
	3																			\					[0a8]
	+																			\					[01e]
	-c@																			\					[96c]
	-c@																			\					[96c]
	-c@																			\					[96c]
	c@																			\					[071]
	bljoin																		\					[07f]
	;																			\					[0c2]

0a constant /cmdbuf																\ (96f 0a)			[010 0b6 0ba]
create cmdbuf																	\ (970)				[0b6 0bb]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: cb!																			\ (971)				[0b6 0b7]
	cmdbuf																		\					[970]
	+																			\					[01e]
	c!																			\					[075]
	;																			\					[0c2]

create eject-cmd																\ (972)				[0b6 0bb]
1b																				\					[010]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
2																				\					[0a7]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]


external

: device-present?																\ (973)				[0ca 0b7]
	parent-set-address															\					[966]
	0=																			\					[034]
	if																			\ (0x5)				[014]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	5																			\					[010]
	" inquiry"																	\					[012]
	$call-parent																\					[209]
	invert																		\					[026]
	;																			\					[0c2]


: eject																			\ (974)				[0ca 0b7]
	my-unit																		\					[20d]
	device-present?																\					[973]
	if																			\ (0x8)				[014]
		eject-cmd																\					[972]
		no-data-command															\					[968]
		drop																	\					[046]
	then																		\					[0b2]
	;																			\					[0c2]


headers

0 instance value deblocker														\ (975 0)			[0a5 0c0 0b6 0b8]

: init-deblocker																\ (976)				[0b6 0b7]
	" "																			\					[012]
	" deblocker"																\					[012]
	$open-package																\					[20f]
	to deblocker																\					[0c3 975]
	deblocker																	\					[975]
	if																			\ (0x7)				[014]
		-1																		\					[0a4]
	else																		\ (0x25)			[013 0b2]
		." Can't open deblocker package"										\					[012 090]
		cr																		\					[092]
		0																		\					[0a5]
	then																		\					[0b2]
	;																			\					[0c2]


external

0 instance value at-eof?														\ (977 0)			[0a5 0c0 0ca 0b8]

headers

0 instance value fixed-len?														\ (978 0)			[0a5 0c0 0b6 0b8]
0 instance value written?														\ (979 0)			[0a5 0c0 0b6 0b8]
0 instance value /tapeblock														\ (97a 0)			[0a5 0c0 0b6 0b8]
create write-eof-cmd															\ (97b)				[0b6 0bb]
10																				\					[010]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]


external

: write-eof																		\ (97c)				[0ca 0b7]
	write-eof-cmd																\					[97b]
	no-data-command																\					[968]
	;																			\					[0c2]



headers

: ?write-eof																	\ (97d)				[0b6 0b7]
	written?																	\					[979]
	if																			\ (0x27)			[014]
		0																		\					[0a5]
		to written?																\					[0c3 979]
		write-eof																\					[97c]
		if																		\ (0x1d)			[014]
			." Can't write file mark."											\					[012 090]
			cr																	\					[092]
		then																	\					[0b2]
	then																		\					[0b2]
	;																			\					[0c2]

create rewind-cmd																\ (97e)				[0b6 0bb]
1																				\					[0a6]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: rewind																		\ (97f)				[0b6 0b7]
	?write-eof																	\					[97d]
	0																			\					[0a5]
	to at-eof?																	\					[0c3 977]
	rewind-cmd																	\					[97e]
	no-data-command																\					[968]
	;																			\					[0c2]

create skip-files-cmd															\ (980)				[0b6 0bb]
11																				\					[010]
c,																				\					[0d0]
1																				\					[0a6]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: skip-files																	\ (981)				[0b6 0b7]
	?write-eof																	\					[97d]
	0																			\					[0a5]
	to at-eof?																	\					[0c3 977]
	skip-files-cmd																\					[980]
	2+																			\					[0a7 01e]
	3c!																			\					[96b]
	skip-files-cmd																\					[980]
	no-data-command																\					[968]
	;																			\					[0c2]

create block-limit-cmd															\ (982)				[0b6 0bb]
5																				\					[010]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]
0																				\					[0a5]
c,																				\					[0d0]

: 2c@																			\ (983)				[0b6 0b7]
	1+																			\					[0a6 01e]
	-c@																			\					[96c]
	c@																			\					[071]
	bwjoin																		\					[0b0]
	;																			\					[0c2]


: get-record-length																\ (984)				[0b6 0b7]
	6																			\					[010]
	block-limit-cmd																\					[982]
	6																			\					[010]
	short-data-command															\					[969]
	if																			\ (0xc)				[014]
		200																		\					[010]
		-1																		\					[0a4]
	else																		\ (0x14)			[013 0b2]
		dup																		\					[047]
		1+																		\					[0a6 01e]
		3c@																		\					[96d]
		swap																	\					[049]
		4																		\					[010]
		+																		\					[01e]
		2c@																		\					[983]
		over																	\					[048]
		=																		\					[03c]
	then																		\					[0b2]
	to fixed-len?																\					[0c3 978]
	dup																			\					[047]
	parent-max-transfer															\					[965]
	u>																			\					[03e]
	if																			\ (0x6)				[014]
		drop																	\					[046]
		parent-max-transfer														\					[965]
	then																		\					[0b2]
	to /tapeblock																\					[0c3 97a]
	;																			\					[0c2]

-1 instance value first-install?												\ (985 -1)			[0a4 0c0 0b6 0b8]

: ili?																			\ (986)				[0b6 0b7]
	2+																			\					[0a7 01e]
	c@																			\					[071]
	20																			\					[010]
	and																			\					[023]
	0<>																			\					[035]
	;																			\					[0c2]


: eof?																			\ (987)				[0b6 0b7]
	dup																			\					[047]
	2+																			\					[0a7 01e]
	c@																			\					[071]
	0c0																			\					[010]
	and																			\					[023]
	0<>																			\					[035]
	swap																		\					[049]
	3																			\					[0a8]
	+																			\					[01e]
	c@																			\					[071]
	0f																			\					[010]
	and																			\					[023]
	8																			\					[010]
	=																			\					[03c]
	or																			\					[024]
	;																			\					[0c2]


: residue																		\ (988)				[0b6 0b7]
	3																			\					[0a8]
	+																			\					[01e]
	4c@																			\					[96e]
	;																			\					[0c2]

0 instance value #requested														\ (989 0)			[0a5 0c0 0b6 0b8]

: actual-#blocks																\ (98a)				[0b6 0b7]
	if																			\ (0x25)			[014]
		if																		\ (0x8)				[014]
			0																	\					[0a5]
			0																	\					[0a5]
		else																	\ (0x19)			[013 0b2]
			>r																	\					[030]
			#requested															\					[989]
			r@																	\					[032]
			ili?																\					[986]
			r@																	\					[032]
			eof?																\					[987]
			or																	\					[024]
			if																	\ (0x7)				[014]
				r@																\					[032]
				residue															\					[988]
				-																\					[01f]
			then																\					[0b2]
			r>																	\					[031]
			eof?																\					[987]
		then																	\					[0b2]
	else																		\ (0x7)				[013 0b2]
		#requested																\					[989]
		0																		\					[0a5]
	then																		\					[0b2]
	to at-eof?																	\					[0c3 977]
	;																			\					[0c2]


: r/w-some																		\ (98b)				[0b6 0b7]
	cmdbuf																		\					[970]
	/cmdbuf																		\					[96f]
	erase																		\					[0a5 079]
	0																			\					[0a5]
	cb!																			\					[971]
	swap																		\					[049]
	fixed-len?																	\					[978]
	if																			\ (0x10)			[014]
		dup																		\					[047]
		to #requested															\					[0c3 989]
		dup																		\					[047]
		/tapeblock																\					[97a]
		*																		\					[020]
		swap																	\					[049]
		1																		\					[0a6]
	else																		\ (0xd)				[013 0b2]
		/tapeblock																\					[97a]
		min																		\					[02e]
		dup																		\					[047]
		to #requested															\					[0c3 989]
		dup																		\					[047]
		0																		\					[0a5]
	then																		\					[0b2]
	1																			\					[0a6]
	cb!																			\					[971]
	cmdbuf																		\					[970]
	2+																			\					[0a7 01e]
	3c!																			\					[96b]
	swap																		\					[049]
	cmdbuf																		\					[970]
	6																			\					[010]
	-1																			\					[0a4]
	retry-command																\					[967]
	actual-#blocks																\					[98a]
	;																			\					[0c2]


: flush-deblocker																\ (98c)				[0b6 0b7]
	deblocker																	\					[975]
	close-package																\					[206]
	init-deblocker																\					[976]
	drop																		\					[046]
	;																			\					[0c2]

0 instance value load-arg-adr													\ (98d 0)			[0a5 0c0 0b6 0b8]
0 instance value load-arg-len													\ (98e 0)			[0a5 0c0 0b6 0b8]

: set-load-args																	\ (98f)				[0b6 0b7]
	to load-arg-len																\					[0c3 98e]
	to load-arg-adr																\					[0c3 98d]
	;																			\					[0c2]


: $=																			\ (990)				[0b6 0b7]
	rot																			\					[04a]
	tuck																		\					[04c]
	<>																			\					[03d]
	if																			\ (0x7)				[014]
		3drop																	\					[8f9]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	comp																		\					[07a]
	0=																			\					[034]
	;																			\					[0c2]


: handle-options																\ (991)				[0b6 0b7]
	my-args																		\					[202]
	dup																			\					[047]
	if																			\ (0x2c)			[014]
		2c																		\					[010]
		left-parse-string														\					[240]
		2dup																	\					[053]
		" fixed"																\					[012]
		$=																		\					[990]
		if																		\ (0x13)			[014]
			2drop																\					[052]
			set-load-args														\					[98f]
			200																	\					[010]
			to /tapeblock														\					[0c3 97a]
			-1																	\					[0a4]
			to fixed-len?														\					[0c3 978]
			exit																\					[033]
		then																	\					[0b2]
		2drop																	\					[052]
		2drop																	\					[052]
		my-args																	\					[202]
	then																		\					[0b2]
	set-load-args																\					[98f]
	;																			\					[0c2]



external

: max-transfer																	\ (992)				[0ca 0b7]
	fixed-len?																	\					[978]
	if																			\ (0xe)				[014]
		parent-max-transfer														\					[965]
		/tapeblock																\					[97a]
		/																		\					[021]
		/tapeblock																\					[97a]
		*																		\					[020]
	else																		\ (0x6)				[013 0b2]
		/tapeblock																\					[97a]
	then																		\					[0b2]
	;																			\					[0c2]


: block-size																	\ (993)				[0ca 0b7]
	fixed-len?																	\					[978]
	if																			\ (0x8)				[014]
		/tapeblock																\					[97a]
	else																		\ (0x5)				[013 0b2]
		1																		\					[0a6]
	then																		\					[0b2]
	;																			\					[0c2]


: read-blocks																	\ (994)				[0ca 0b7]
	nip																			\					[04d]
	at-eof?																		\					[977]
	if																			\ (0x6)				[014]
		2drop																	\					[052]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	-1																			\					[0a4]
	8																			\					[010]
	r/w-some																	\					[98b]
	;																			\					[0c2]


: write-blocks																	\ (995)				[0ca 0b7]
	nip																			\					[04d]
	-1																			\					[0a4]
	to written?																	\					[0c3 979]
	0																			\					[0a5]
	0a																			\					[010]
	r/w-some																	\					[98b]
	;																			\					[0c2]


: open																			\ (996)				[0ca 0b7]
	my-unit																		\					[20d]
	" set-address"																\					[012]
	$call-parent																\					[209]
	first-install?																\					[985]
	if																			\ (0x24)			[014]
		rewind																	\					[97f]
		if																		\ (0x1a)			[014]
			." Can't rewind tape"												\					[012 090]
			cr																	\					[092]
			0																	\					[0a5]
			exit																\					[033]
		then																	\					[0b2]
		0																		\					[0a5]
		to first-install?														\					[0c3 985]
	then																		\					[0b2]
	get-record-length															\					[984]
	handle-options																\					[991]
	init-deblocker																\					[976]
	;																			\					[0c2]


: close																			\ (997)				[0ca 0b7]
	deblocker																	\					[975]
	?dup																		\					[050]
	0<>																			\					[035]
	if																			\ (0x9)				[014]
		close-package															\					[206]
		0																		\					[0a5]
		to deblocker															\					[0c3 975]
	then																		\					[0b2]
	?write-eof																	\					[97d]
	;																			\					[0c2]


: read																			\ (998)				[0ca 0b7]
	" read"																		\					[012]
	deblocker																	\					[975]
	$call-method																\					[20e]
	;																			\					[0c2]


: write																			\ (999)				[0ca 0b7]
	" write"																	\					[012]
	deblocker																	\					[975]
	$call-method																\					[20e]
	flush-deblocker																\					[98c]
	;																			\					[0c2]

0 value buf																		\ (99a 0)			[0a5 0ca 0b8]
200 constant /buf																\ (99b 200)			[010 0ca 0ba]

: seek																			\ (99c)				[0ca 0b7]
	flush-deblocker																\					[98c]
	rewind																		\					[97f]
	if																			\ (0x6)				[014]
		2drop																	\					[052]
		-1																		\					[0a4]
		exit																	\					[033]
	then																		\					[0b2]
	?dup																		\					[050]
	if																			\ (0xc)				[014]
		skip-files																\					[981]
		if																		\ (0x6)				[014]
			drop																\					[046]
			-1																	\					[0a4]
			exit																\					[033]
		then																	\					[0b2]
	then																		\					[0b2]
	?dup																		\					[050]
	if																			\ (0x2b)			[014]
		/buf																	\					[99b]
		alloc-mem																\					[08b]
		to buf																	\					[0c3 99a]
		begin																	\					[0b1]
			dup																	\					[047]
			0>																	\					[038]
			while																\ (0x18)			[014]
				buf																\					[99a]
				over															\					[048]
				/buf															\					[99b]
				min																\					[02e]
				read															\					[998]
				dup																\					[047]
				0=																\					[034]
				if																\ (0x6)				[014]
					2drop														\					[052]
					-1															\					[0a4]
					exit														\					[033]
				then															\					[0b2]
				-																\					[01f]
		repeat																	\ (0xffe8)			[013 0b2]
		drop																	\					[046]
		buf																		\					[99a]
		/buf																	\					[99b]
		free-mem																\					[08c]
	then																		\					[0b2]
	0																			\					[0a5]
	;																			\					[0c2]


: load																			\ (99d)				[0ca 0b7]
	load-arg-len																\					[98e]
	if																			\ (0x2e)			[014]
		load-arg-adr															\					[98d]
		load-arg-len															\					[98e]
		$number																	\					[0a2]
		if																		\ (0x22)			[014]
			." Invalid tape file number"										\					[012 090]
			cr																	\					[092]
			drop																\					[046]
			0																	\					[0a5]
			exit																\					[033]
		then																	\					[0b2]
	else																		\ (0x5)				[013 0b2]
		0																		\					[0a5]
	then																		\					[0b2]
	0																			\					[0a5]
	swap																		\					[049]
	seek																		\					[99c]
	if																			\ (0x2d)			[014]
		." Can't select the requested tape file"								\					[012 090]
		cr																		\					[092]
		0																		\					[0a5]
		exit																	\					[033]
	then																		\					[0b2]
	70000000																	\					[010]
	read																		\					[998]
	;																			\					[0c2]


: size																			\ (99e)				[0ca 0b7]
	-1																			\					[0a4]
	dup																			\					[047]
	1f																			\					[010]
	rshift																		\					[028]
	;																			\					[0c2]


: #blocks																		\ (99f)				[0ca 0b7]
	-1																			\					[0a4]
	;																			\					[0c2]

finish-device																	\					[127]

fcode-end
\ detokenizing finished after 17714 of 17714 bytes.

pci-end
